/***************************************************************/
//
//
//		System	[ number.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/27
/*---------------------------------------------------------------
Update : 2017/6/27
			Create Header File -> number.h.h 
 			< Add Class Function >
				NUMBER->Constructor
				NUMBER->Destructor
				NUMBER->Create ( static member )
				NUMBER->Init
				NUMBER->Uninit
				NUMBER->Update
				NUMBER->Draw

Update : 2017/6/27



/*-------------------------------------------------------------*/
#ifndef _NUMBER_H_

#define _NUMBER_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "userinterface.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Number Using Number
class Number : public UserInterface
{
public:

	Number(							 // Number Constructor
		const std::string& filename,
		const float& vertical = 0.5f,
		const float& horizonal = 0.5f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,1.0f),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	
	
	~Number( );						// Number Destructor

	static Number* Create( 			// Number Create Instance Class
		const float& vertical = 0.5f,
		const float& horizonal = 0.5f,
		const Vector3& pos = Vector3(0,0,1.0f),
		const std::string& filename = "data\\TEXTURE\\degifont.png",
		const Color& color = Color(1,1,1,1),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	

	void Init( void );				// Number Initialize
	void Uninit( void );			// Number Uninitialize
	void Update( void );			// Number Update

	void SetNumber( 
		const int number );


private:

	// Member Variable


};


#endif	//	_NUMBER_H_


