/***************************************************************/
//
//
//		DirectX	[ pauselist.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 9/18
/*---------------------------------------------------------------
Update : 2016/9/18
			pauselist.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "pause_list.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

#define SCREEN_WIDTH (1280)
#define SCREEN_HEIGHT (720)

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define NUM_VERTEX  ( 4 )								// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )								// `悷|S

#define START_COORD_X (0)								// \WSX
#define START_COORD_Y (0)								// \ʒuSY
//#define END_COORD_X   (300)								// \WEX
//#define END_COORD_Y   (104)								// \WEX

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexPauseList( LPDIRECT3DDEVICE9 pDevice );				// _̍쐬
void SetVertexPauseListCoord( VERTEX_2D* pVtx, const int index );		// _W̐ݒ
void SetVertexPauseListSpriteUV( VERTEX_2D* pVtx, const int index );	// _UVl̐ݒ
void SetVertexPauseListColor( VERTEX_2D* pVtx, const int index );		// _F̐ݒ

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTexturePauseList[ PAUSE_MAX ] = {};			// eNX`-C^[tF-X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferPauseList = nullptr;			// _obt@C^[tF[Xւ̃|C^


// PAUSELIST̏
void InitPauseList( void )
{

	// t@Cl[萔
	const char* TEXTURE_NAME[ ] = {

		"data/TEXTURE/continue.png",
		"data/TEXTURE/retry.png",
		"data/TEXTURE/quit.png",
	};

	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexPauseList( pDevice );

	// eNX`̓ǂݍ 
	for( int index = 0; index < PAUSE_MAX; index++ ){
		if( FAILED( D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME[index], &g_pTexturePauseList[index] )))
		{
			#ifdef _DEBUG
			MessageBox( NULL, "PAUSELISTeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
			#endif	// _DEBUG
		}
	}


}

// PAUSELIST̏I
void UninitPauseList( void )
{

	// eNX`C^[tF[X̊J
	for( int index = 0; index < PAUSE_MAX; index++ ){
		SAFE_RELEASE( g_pTexturePauseList[index] )
	}

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( g_pVtxBufferPauseList )

}

// PAUSELIST̍XV
void UpdatePauseList( void )
{

	VERTEX_2D *pVtx;										// zAhX


	// obt@bNzAhX擾
	g_pVtxBufferPauseList -> Lock( 0, 0, (void**)&pVtx, 0 );

	
	// _obt@̐ݒ
	for( int index = 0; index < PAUSE_MAX; index++ ){

		// _W̐ݒ
		//SetVertexPauseListCoord( pVtxAindex );

		// _UVl̐ݒ
		//SetVertexPauseListSpriteUV( pVtx, index );

		// _F̐ݒ
		SetVertexPauseListColor( pVtx, index );

		// rhw̐ݒ
		//pVtx[0].rhw = 1.0f;
		//pVtx[1].rhw = 1.0f;
		//pVtx[2].rhw = 1.0f;
		//pVtx[3].rhw = 1.0f;


	}// SetVertex -> END 


	g_pVtxBufferPauseList ->Unlock( );


}

// PAUSELIST̕`
void DrawPauseList( void )
{


	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferPauseList,							// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_2D ));							// ̃XgChl(oCgP)


	// _tH[}bg̐ݒ
	pDevice ->SetFVF( FVF_VERTEX_2D );

	for( int index = 0; index < PAUSE_MAX; index++ ){

		// eNX`̐ݒ
		pDevice ->SetTexture( 0, g_pTexturePauseList[index] );

		// |S̕`
		pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, NUM_VERTEX * index, NUM_POLYGON );
	}


}

// _̍쐬
HRESULT MakeVertexPauseList( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;									// zAhX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_2D ) * NUM_VERTEX * PAUSE_MAX,	// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&g_pVtxBufferPauseList,						// i[|C^
			NULL )))
	{

		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " PAUSELIST VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return E_FAIL;

	}


	// zAhX̎擾
	g_pVtxBufferPauseList -> Lock( 0, 0, (void**)&pVtx, 0 );


	// _obt@̐ݒ
	for( int index = 0; index < PAUSE_MAX; index++ ){


		// _W̐ݒ
		SetVertexPauseListCoord( pVtx, index );

		// _UVl̐ݒ
		SetVertexPauseListSpriteUV( pVtx, index );

		// _F̐ݒ
		SetVertexPauseListColor( pVtx, index );

		// rhw̐ݒ
		pVtx[0 + (NUM_VERTEX * index)].rhw = 1.0f;
		pVtx[1 + (NUM_VERTEX * index)].rhw = 1.0f;
		pVtx[2 + (NUM_VERTEX * index)].rhw = 1.0f;
		pVtx[3 + (NUM_VERTEX * index)].rhw = 1.0f;

	}// SetVertex -> END 


	// obt@̃AbN
	g_pVtxBufferPauseList ->Unlock( );

	return S_OK;


}

// _W̐ݒ
void SetVertexPauseListCoord( VERTEX_2D* pVtx, const int index )
{


	D3DXVECTOR2 start,end;				// n_ƏI_
	D3DXVECTOR2 center;					// SW
	D3DXVECTOR2 radius;					// XvCga
	D3DXVECTOR2 coord[ NUM_VERTEX ];	// W̌vZli[p
	static float arc;					// ]px
	static float scale = 1.0f;			// gkl

	const int END_COORD_X[ ] = {
		300,
		224,
		162
	};

	const int END_COORD_Y[ ] = {
		104,
		88,
		104
	};

	{ // Wl

		// a̐ݒ
		radius.x = (( END_COORD_X[index] - START_COORD_X ) * 0.5f ); 
		radius.y = (( END_COORD_Y[index] - START_COORD_Y ) * 0.5f ); 

		// SW̐ݒ
		center.x = SCREEN_WIDTH >> 1;
		center.y = (float)( SCREEN_HEIGHT >> 1 ) + ( LIST_PADDING * index ) - 120;

	} // -> ݒI



	// XvCggk
	scale += 0.0f;

	{ // XP[

		radius *= scale;

	}

	// XvCg]
	arc -= 0;

	{ // AtBϊ


		coord[ 0 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, -radius.y, arc );
		coord[ 0 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, -radius.y, arc );

		coord[ 1 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, -radius.y, arc );
		coord[ 1 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, -radius.y, arc );

		coord[ 2 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, radius.y, arc );
		coord[ 2 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, radius.y, arc );

		coord[ 3 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, radius.y, arc );
		coord[ 3 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, radius.y, arc );


	} // -> ϊI


	// W̏
	for( int inc = 0; inc < NUM_VERTEX; inc++ )
	{
		pVtx[ inc + (NUM_VERTEX * index) ].pos=D3DXVECTOR3( coord[ inc ].x, coord[ inc ].y  , 0.0f );
	}
	


	/*
	// W̐ݒ
	start.x = START_COORD_X;
	start.y = START_COORD_Y;
	end.x   = END_COORD_X;
	end.y   = END_COORD_Y;


	// W̏
	pVtx[0].pos=D3DXVECTOR3( start.x, start.y, 0.0f );
	pVtx[1].pos=D3DXVECTOR3( end.x  , start.y, 0.0f );
	pVtx[2].pos=D3DXVECTOR3( start.x, end.y  , 0.0f );
	pVtx[3].pos=D3DXVECTOR3( end.x  , end.y  , 0.0f );
	*/

}

// _UVl̐ݒ
void SetVertexPauseListSpriteUV( VERTEX_2D* pVtx, const int index )
{


	const unsigned int TEXTURE_SHEETS_U = 1;		// eNX`Aj[V
	const unsigned int TEXTURE_SHEETS_V = 1;		// eNX`cAj[V
	const unsigned int FPS = 1 ;					// t[p[ZJh(҂)
	const float TEXTURE_U = 1.0f / TEXTURE_SHEETS_U;// eNX` U l萔
	const float TEXTURE_V = 1.0f / TEXTURE_SHEETS_V;// eNX` V l萔
	float TexU = 0,TexV = 0;						// eNX`UVľvZɎgp
	static unsigned int animationFrame;				// Aj[Vt[



	// UVľvZ
	TexU = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_U ) * TEXTURE_U;
	TexV = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_V ) * TEXTURE_V;


	// _UVl̏
	pVtx[0 + (NUM_VERTEX * index) ].tex = D3DXVECTOR2( TexU            , TexV );
	pVtx[1 + (NUM_VERTEX * index) ].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV );
	pVtx[2 + (NUM_VERTEX * index) ].tex = D3DXVECTOR2( TexU            , TexV + TEXTURE_V );
	pVtx[3 + (NUM_VERTEX * index) ].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV + TEXTURE_V );


	// Aj[Vt[̍XV
	animationFrame ++;


}

// _F̐ݒ
void SetVertexPauseListColor( VERTEX_2D* pVtx, const int index )
{

	static D3DXCOLOR vertexColor = D3DXCOLOR( 1.0f, 1.0f, 1.0f, 1.0f );	// _F

	const float MAX_COLOR = 1.0f;										// F̍ől
	const float MIM_COLOR = 0.6f;										// F̍ŏl
	const float TRANSLATE_COLOR = 0.001f;								// t[̐F̍XVl
	static float transitionColor = 0.7f;								// FύXl
	static bool frag = true;											// ܂ԂtO


	// F̑J
	if( transitionColor >= MAX_COLOR ){

		frag = false;

	}

	if( frag ){

		transitionColor += TRANSLATE_COLOR;
	}
	else{

		transitionColor -= TRANSLATE_COLOR;

		if( transitionColor <= MIM_COLOR ){

			frag = true;
		}

	}



	{ // _F̍XV


		vertexColor.r = transitionColor; 
		vertexColor.g = transitionColor; 
		vertexColor.b = transitionColor; 
		//vertexColor.a = transitionColor; 

	}



	// _F̏
	pVtx[0 + (NUM_VERTEX * index) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[1 + (NUM_VERTEX * index) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[2 + (NUM_VERTEX * index) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[3 + (NUM_VERTEX * index) ].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );



}


