/***************************************************************/
//
//
//		DirectX	[ PauseManager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/31
/*---------------------------------------------------------------
Update : 2017/1/31
			Create CPP -> PauseManager.cpp

/*---------------------------------------------------------------
	include File
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include "main.h"
#include "pause_manager.h"

#include "pause.h"
#include "pause_menu.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

/*----------------------------------------------------------------
	static member variable Initialize
----------------------------------------------------------------*/




// CPauseManager constructor
CPauseManager::CPauseManager( )
{

	// Member Initialize


}

// CPauseManager destructor
CPauseManager::~CPauseManager( )
{

    // Do Nothing!!

}

// CPauseManager Create 
CPauseManager* CPauseManager::Create( const char* EVENT_NAME )
{

	// Create Class Instance
	CPauseManager* pObject;
	pObject = new CPauseManager;

	pObject ->SetEventName( EVENT_NAME );

	return pObject;

}

// Initialize
void CPauseManager::Init( void )
{
	
	InitPause( );
	InitPauseMenu( );

}

// Uninitialize
void CPauseManager::Uninit( void )
{

	UninitPause( );
	UninitPauseMenu( );

}

// Update
void CPauseManager::Update( void )
{

	UpdatePause( );
	UpdatePauseMenu( );

	if( GetPause( ) == false ){
	
		CEvent::EventEnd( );
	}

}

// Draw
void CPauseManager::Draw( void )
{

	DrawPause( );
	DrawPauseMenu( );

}



