/***************************************************************/
//
//
//		DirectX	[ pausemenu.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 9/17
/*---------------------------------------------------------------
Update : 2016/9/17
			pausemenu.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "pause_menu.h"

#include "pause.h"

#include "window_frame.h"
#include "pause_list.h"

#include "screen_transition.h"
#include "game.h"
#include "main_scene.h"

#include "input.h"
#include "keyboard.h"
#include "mouse.h"

#include "event.h"

#include "xboxcontroller.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))

typedef int PAUSE_SELECT;

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NAME "data/TEXTURE/select_frame.png"	// eNX`
//#define TEXTURE_NAME "data/TEXTURE/frame000.jpg"		// eNX`


#define NUM_VERTEX  ( 4 )								// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )								// `悷|S

#define START_COORD_X (0)								// \WSX
#define START_COORD_Y (0)								// \ʒuSY
#define END_COORD_X   (360)								// \WEX
#define END_COORD_Y   (70)								// \WEX


/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexPauseMenu( LPDIRECT3DDEVICE9 pDevice );				// _̍쐬
void SetVertexPauseMenuCoord( VERTEX_2D* pVtx, const int index );		// _W̐ݒ
void SetVertexPauseMenuSpriteUV( VERTEX_2D* pVtx, const int index );	// _UVl̐ݒ
void SetVertexPauseMenuColor( VERTEX_2D* pVtx, const int index );		// _F̐ݒ
void ControlPauseSelect( void );										// |[Y̑

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTexturePauseMenu = nullptr;			// eNX`-C^[tF-X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferPauseMenu = nullptr;	// _obt@C^[tF[Xւ̃|C^

PAUSE_SELECT g_pauseSelect = PAUSE_CONTINUE;				// IĂ|[Yj[



// PAUSEMENȔ
void InitPauseMenu( void )
{

	// PAUSE COMPONENTS̏
	InitWindowFrame( );
	InitPauseList( );

	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexPauseMenu( pDevice );

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME, &g_pTexturePauseMenu )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "PAUSEMENUeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}

}

// PAUSEMENȔI
void UninitPauseMenu( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE( g_pTexturePauseMenu )
	

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( g_pVtxBufferPauseMenu )

	// PAUSE COMPONENTS̏I
	UninitWindowFrame( );
	UninitPauseList( );

}

// PAUSEMENU̍XV
void UpdatePauseMenu( void )
{

	VERTEX_2D *pVtx;										// zAhX


	// |[Yt[̑
	ControlPauseSelect( );


	// PAUSE COMPONENTS̍XV
	UpdateWindowFrame( );
	UpdatePauseList( );

	// obt@bNzAhX擾
	g_pVtxBufferPauseMenu -> Lock( 0, 0, (void**)&pVtx, 0 );

	///*
	// _obt@̐ݒ
	for( int index = 0; index < 3; index++ ){


		// _W̐ݒ
		SetVertexPauseMenuCoord( pVtx, index );

		// _UVl̐ݒ
		//SetVertexPauseMenuSpriteUV( pVtx, index );

		// _F̐ݒ
		SetVertexPauseMenuColor( pVtx, index );

		// rhw̐ݒ
		//pVtx[0].rhw = 1.0f;
		//pVtx[1].rhw = 1.0f;
		//pVtx[2].rhw = 1.0f;
		//pVtx[3].rhw = 1.0f;


	}// SetVertex -> END 
	//*/

	g_pVtxBufferPauseMenu ->Unlock( );


}

// PAUSEMENU̕`
void DrawPauseMenu( void )
{


	if( GetPause( ) && GetEventPause( ) == DEFAULT ){


		// PAUSE COMPONENTS̕`揈
		DrawWindowFrame( );
		DrawPauseList( );


		// foCX̎󂯎菈
		LPDIRECT3DDEVICE9 pDevice = GetDevice( );


		// Xg[
		pDevice ->SetStreamSource( 0,
		g_pVtxBufferPauseMenu,							// Xg[ɃoCh钸_obt@
		0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
		sizeof( VERTEX_2D ));							// ̃XgChl(oCgP)


		// _tH[}bg̐ݒ
		pDevice ->SetFVF( FVF_VERTEX_2D );


		// eNX`̐ݒ
		pDevice ->SetTexture( 0, g_pTexturePauseMenu );

		// Z̐ݒ
		pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );		
		pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
		pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );		
	
		// |S̕`
		for( int index = 0; index < 1; index++ ){

			pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, NUM_VERTEX * index, NUM_POLYGON );
		}

		// ̏Ԃɖ߂
		pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
		pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );
	
	}


}

// _̍쐬
HRESULT MakeVertexPauseMenu( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;									// zAhX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_2D ) * NUM_VERTEX * 3,		// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&g_pVtxBufferPauseMenu,						// i[|C^
			NULL )))
	{

		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " PAUSEMENU VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return E_FAIL;
	}


	// zAhX̎擾
	g_pVtxBufferPauseMenu -> Lock( 0, 0, (void**)&pVtx, 0 );


	// _obt@̐ݒ
	for( int index = 0; index < 3; index++ ){

		// _W̐ݒ
		SetVertexPauseMenuCoord( pVtx, index );

		// _UVl̐ݒ
		SetVertexPauseMenuSpriteUV( pVtx, index );

		// _F̐ݒ
		SetVertexPauseMenuColor( pVtx, index );

		// rhw̐ݒ
		pVtx[ 0 + ( NUM_VERTEX * index )].rhw = 1.0f;
		pVtx[ 1 + ( NUM_VERTEX * index )].rhw = 1.0f;
		pVtx[ 2 + ( NUM_VERTEX * index )].rhw = 1.0f;
		pVtx[ 3 + ( NUM_VERTEX * index )].rhw = 1.0f;

	}// SetVertex -> END 


	// obt@̃AbN
	g_pVtxBufferPauseMenu ->Unlock( );

	return S_OK;


}

// _W̐ݒ
void SetVertexPauseMenuCoord( VERTEX_2D* pVtx, const int index )
{


	D3DXVECTOR2 start,end;				// n_ƏI_
	D3DXVECTOR2 center;					// SW
	D3DXVECTOR2 radius;					// XvCga
	D3DXVECTOR2 coord[ NUM_VERTEX ];	// W̌vZli[p
	static float arc;					// ]px
	static float scale = 1.0f;			// gkl



	{ // Wl

		// a̐ݒ
		radius.x = (( END_COORD_X - START_COORD_X ) * 0.5f ); 
		radius.y = (( END_COORD_Y - START_COORD_Y ) * 0.5f ); 

		// SW̐ݒ
		//center.x = ( SCREEN_WIDTH >> 1 )  + radius.x;
		//center.y = ( SCREEN_HEIGHT >> 1 ) + radius.y + ( index * 10 ) -10;
		center.x = ( Window::SCREEN_WIDTH >> 1 );
		center.y = (float)( Window::SCREEN_HEIGHT >> 1 ) + ( index * 10 ) -10 - LIST_PADDING + ( LIST_PADDING * g_pauseSelect );


	} // -> ݒI



	// XvCggk
	scale += 0.0f;

	{ // XP[

		radius *= scale;

	}

	// XvCg]
	arc -= 0;

	{ // AtBϊ


		coord[ 0 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, -radius.y, arc );
		coord[ 0 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, -radius.y, arc );

		coord[ 1 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, -radius.y, arc );
		coord[ 1 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, -radius.y, arc );

		coord[ 2 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, radius.y, arc );
		coord[ 2 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, radius.y, arc );

		coord[ 3 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, radius.y, arc );
		coord[ 3 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, radius.y, arc );


	} // -> ϊI


	// W̏
	for( int inc = 0; inc < NUM_VERTEX; inc++ )
	{
		pVtx[ inc + ( NUM_VERTEX * index ) ].pos=D3DXVECTOR3( coord[ inc ].x, coord[ inc ].y  , 0.0f );
	}
	
	/*
	// W̐ݒ
	start.x = START_COORD_X;
	start.y = START_COORD_Y;
	end.x   = END_COORD_X;
	end.y   = END_COORD_Y;


	// W̏
	pVtx[0].pos=D3DXVECTOR3( start.x, start.y, 0.0f );
	pVtx[1].pos=D3DXVECTOR3( end.x  , start.y, 0.0f );
	pVtx[2].pos=D3DXVECTOR3( start.x, end.y  , 0.0f );
	pVtx[3].pos=D3DXVECTOR3( end.x  , end.y  , 0.0f );
	*/

}

// _UVl̐ݒ
void SetVertexPauseMenuSpriteUV( VERTEX_2D* pVtx, const int index )
{


	const unsigned int TEXTURE_SHEETS_U = 1;		// eNX`Aj[V
	const unsigned int TEXTURE_SHEETS_V = 1;		// eNX`cAj[V
	const unsigned int FPS = 1 ;					// t[p[ZJh(҂)
	const float TEXTURE_U = 1.0f / TEXTURE_SHEETS_U;// eNX` U l萔
	const float TEXTURE_V = 1.0f / TEXTURE_SHEETS_V;// eNX` V l萔
	float TexU = 0,TexV = 0;						// eNX`UVľvZɎgp
	static unsigned int animationFrame;				// Aj[Vt[



	// UVľvZ
	TexU = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_U ) * TEXTURE_U;
	TexV = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_V ) * TEXTURE_V;


	// _UVl̏
	pVtx[ 0 + ( NUM_VERTEX * index )].tex = D3DXVECTOR2( TexU            , TexV );
	pVtx[ 1 + ( NUM_VERTEX * index )].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV );
	pVtx[ 2 + ( NUM_VERTEX * index )].tex = D3DXVECTOR2( TexU            , TexV + TEXTURE_V );
	pVtx[ 3 + ( NUM_VERTEX * index )].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV + TEXTURE_V );


	// Aj[Vt[̍XV
	animationFrame ++;


}

// _F̐ݒ
void SetVertexPauseMenuColor( VERTEX_2D* pVtx, const int index )
{

	static D3DXCOLOR vertexColor = D3DXCOLOR( 0.2f, 0.3f, 0.2f, 0.3f );	// _F

	const float MAX_COLOR = 0.8f;										// F̍ől
	const float MIM_COLOR = 0.3f;										// F̍ŏl
	const float TRANSLATE_COLOR = 0.005f;								// t[̐F̍XVl
	static float transitionColor = 0.3f;								// FύXl
	static bool frag = true;											// ܂ԂtO


	// F̑J
	if( transitionColor >= MAX_COLOR ){

		frag = false;

	}

	if( frag ){

		transitionColor += TRANSLATE_COLOR;
	}
	else{

		transitionColor -= TRANSLATE_COLOR;

		if( transitionColor <= MIM_COLOR ){

			frag = true;
		}

	}



	{ // _F̍XV


		//vertexColor.r = transitionColor; 
		vertexColor.g = transitionColor; 
		//vertexColor.b = transitionColor; 
		//vertexColor.a = transitionColor; 

	}



	// _F̏
	pVtx[ 0 + ( NUM_VERTEX * index )].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 1 + ( NUM_VERTEX * index )].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 2 + ( NUM_VERTEX * index )].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[ 3 + ( NUM_VERTEX * index )].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );



}

// |[Y[h̑I𑀍
void ControlPauseSelect( void )
{

	// |[Y[h̑I𑀍
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_UP ) ){
	
		g_pauseSelect--;
		if( g_pauseSelect < PAUSE_CONTINUE ){
			g_pauseSelect = PAUSE_MAX - 1;
		}
	}

	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_DOWN ) ){
	
		g_pauseSelect++;
		if( g_pauseSelect > PAUSE_MAX - 1 ){
			g_pauseSelect = PAUSE_CONTINUE;
		}
	}

	// |[Y
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_A ) )
	{
		switch( g_pauseSelect ){
		
		case PAUSE_CONTINUE: 

			g_pauseSelect = PAUSE_CONTINUE;
			SetEnablePause( false );
			break;

		case PAUSE_RETRY:
			ScreenTransition::Transition( ScreenTransition::DO_TRANSITION, new GameScene::Game(SET_GAME) );
			SetEnablePause( false );
			break;

		case PAUSE_QUIT:
			ScreenTransition::Transition( ScreenTransition::DO_TRANSITION, new GameScene::Main );
			SetEnablePause( false );
			break;

		default:
			break;
		}
	}


}




