/***************************************************************/
//
//
//		DirectX	[ playercontrol.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/22
/*---------------------------------------------------------------
Update : 2017/6/22
			playercontrol.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "system_component.h"

#include "playercontrol.h"

#include "meshplane.h"

#include "fieldmap.h"

#include "immortal.h"
#include "shell.h"
#include "start.h"

#include "game.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// PlayerControl Constructor
PlayerControl::PlayerControl( const Vector3& pos )
	: pos(pos)
{

	// Menber Clear Process

}

// PlayerControl Destructor
PlayerControl::~PlayerControl( )
{

	// Do Nothing!!

}

// PlayerControl Create Instance 
PlayerControl* PlayerControl::Create( const Vector3& pos )
{

	// Create Class Instance
	PlayerControl* pObject;
	pObject = new PlayerControl(pos);

	return pObject;

}

// PlayerControl Initialize
void PlayerControl::Init( void )
{

	// Initialize Process
	player = MeshPlane::Create(
		"data\\TEXTURE\\background.jpg",
		MAP_SIZE,
		MAP_SIZE,
		Color(1,1,1,1.0f),
		pos,
		Vector3(_PI*0.5f,0,0) );

	shell = 45;

	player->Init();
	
	
	number = Score::Create( );
	number->Init( 3, shell );


	input = CXboxController::Create("playerController");

	current = 0;
	
}

// PlayerControl Uninitialize
void PlayerControl::Uninit( void )
{

	// Uninitialize Process
	player->Uninit();
	number->Uninit();

}

// PlayerControl Update
void PlayerControl::Update( void )
{

	// Update Process
	player->Update();
	player->ReCalcMatrix();
		
	number->SetValue(shell);
	number->Update();


	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_B )){
		ScreenTransition::Transition( ScreenTransition::DO_TRANSITION ,new GameScene::Game(SET_GAME) );
	}

	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_RIGHT_SHOULDER )){
		current ++;
		if( current > 3 ){
			current = 0;
		}
	}
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_LEFT_SHOULDER )){
		current --;
		if( current < 0 ){
			current = 3;
		}
	}

	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_LEFT )){
		player->SetPosition( player->GetPosition()+Vector3(-MAP_SIZE,0,0) );
	}
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_RIGHT )){
		player->SetPosition( player->GetPosition()+Vector3(MAP_SIZE,0,0) );
	}
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_UP )){
		player->SetPosition( player->GetPosition()+Vector3(0,0,MAP_SIZE) );
	}
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_DOWN )){
		player->SetPosition( player->GetPosition()+Vector3(0,0,-MAP_SIZE) );
	}
	if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_A )){

		if( shell ){
			Base* obj = Model::Instance<Shell>("data\\MODEL\\hotate.x",player->GetPosition() );
			FieldMap::PutObject( (FieldMap::TYPE)current, obj );
			shell--;
		}
		//pool--;
	}

	CDebugFont::Access()->SetRenderData( R_RENDER, " type : %d \n pos : %f %f %f \n",current, player->GetPosition().x, player->GetPosition().y, player->GetPosition().z );



}






