/***************************************************************/
//
//
//		DirectX	[ renderer.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/10
/*---------------------------------------------------------------
Update : 2017/5/10
			Create Header File -> renderer.h.h 
 			< Add Class Function >
				Renderer->Constructor
				Renderer->Destructor
				Renderer->Create ( static member )
				Renderer->Init
				Renderer->Uninit
				Renderer->Update
				Renderer->Draw

Update : 2017/5/10



/*-------------------------------------------------------------*/
#ifndef _RENDERER_H_

#define _RENDERER_H_

#include <Windows.h>

/*---------------------------------------------------------------
	CLASS
---------------------------------------------------------------*/

// class Renderer Using Renderer
class Renderer
{
public:

	// Renderer Type
	typedef enum{

		RENDERER_DX9 = 0,
		RENDERER_DX11,
		RENDERER_GL,
		RENDERER_WINAPI,
		RENDERER_MAX
	}TYPE;
	
	Renderer( );							// Renderer constructor
	~Renderer( );							// Renderer destructor

	virtual void Init(						// Renderer Initialize
		HWND hWnd,
		bool bWindow = true ) = 0;	
	virtual void Uninit( void ) = 0;		// Renderer Uninitialize
	virtual bool RenderBegin( void )		// Renderer Draw Start
	{ return true; }				
	virtual void RenderEnd( void ){ }		// Renderer Draw End
	virtual void Present( void ){ }			// Renderer Present Process

	virtual void RenderState( 
		int* stateArray,
		bool* flaglist,
		int dataNumber = 1 ){};
private:

	// Member Function
	

};


#endif	//	_RENDERER_H_


