/***************************************************************/
//
//
//		DirectX	[ rendereropengl.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/16
/*---------------------------------------------------------------
Update : 2017/5/16
			rendereropengl.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "rendereropengl.h"

#include "gllight.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// RendererOpenGL Constructor
RendererOpenGL::RendererOpenGL( )
	: hWnd(nullptr)
	, hGLRC(nullptr)
	, hDC(nullptr)
{

	// Menber Clear Process

}

// RendererOpenGL Destructor
RendererOpenGL::~RendererOpenGL( )
{

	// Do Nothing!!

}

// RendererOpenGL Reate Instance 
Renderer* RendererOpenGL::Create( void )
{

	// Reate Class Instance
	RendererOpenGL* pObject;
	pObject = new RendererOpenGL;

	return pObject;

}

// RendererOpenGL Initialize
void RendererOpenGL::Init( HWND hWnd, bool bWindow )
{

	// Initialize Process

	// Save Window Handle
	RendererOpenGL::hWnd = hWnd;

	// Pixel Format 
	PIXELFORMATDESCRIPTOR pfd = {
	
		sizeof( PIXELFORMATDESCRIPTOR ),	// 
		1,									// 
		PFD_DRAW_TO_WINDOW |				// 
		PFD_SUPPORT_OPENGL | 
		PFD_DOUBLEBUFFER,
		PFD_TYPE_RGBA,						// 
		24,									// 
		0, 0, 0, 0, 0, 0,					// 
		0,									// 
		0,									// 
		0,									// 
		0, 0, 0, 0,							// 
		32,									// 
		0,									// 
		0,									// 
		PFD_MAIN_PLANE,						// 
		0,									// 
		0, 0, 0,							// 

	};

	// Take WindowsDeviceContext
	RendererOpenGL::hDC = GetDC( RendererOpenGL::hWnd );

	int pixelFormat = ChoosePixelFormat( RendererOpenGL::hDC, &pfd );
	SetPixelFormat( RendererOpenGL::hDC, pixelFormat, &pfd );

	// Create GLContext
	hGLRC = wglCreateContext( RendererOpenGL::hDC );
	wglMakeCurrent( RendererOpenGL::hDC, hGLRC );

	// polygon wireframe
	glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
	//glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );

	// Setting Rendering Process #OpenGL#
	glEnable( GL_CULL_FACE );				// Use Curring
	glEnable( GL_DEPTH_TEST );				// Use ZBuffer
	glEnable( GL_LIGHTING );				// Use LIGHT
	glEnable( GL_TEXTURE_2D );				// Use Texture

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);

	GLLight light;
	light.diffuse = Color( 1, 1, 1, 1 );
	light.ambient = Color( 0.3, 0.3, 0.3, 0.3 );
	light.specular = Color( 1, 1, 1, 1 );
	light.pos = Vector3( 1, 1, 1 );

	// Cg̐ݒ
	glLightfv( GL_LIGHT0, GL_DIFFUSE,  (float*)&light.diffuse );
	glLightfv( GL_LIGHT0, GL_SPECULAR, (float*)&light.specular );
	glLightfv( GL_LIGHT0, GL_AMBIENT,  (float*)&light.ambient );
	glLightfv( GL_LIGHT0, GL_POSITION, (float*)&light.pos );

	glEnable( GL_LIGHT0 );

	glDepthFunc( GL_LEQUAL );				// DepthTest(for2D?


}

// RendererOpenGL Uninitialize
void RendererOpenGL::Uninit( void )
{

	// Uninitialize Process

	// OpenGL End
	wglMakeCurrent( NULL, NULL );
	ReleaseDC( hWnd, hDC );
	wglDeleteContext( hGLRC );

}

// RendererOpenGL Update
bool RendererOpenGL::RenderBegin( void )
{

	// Clear Buffer
	glClearColor( 192.0f/255.0f, 192.0f/255.0f, 192.0f/255.0f, 0.0f );
	glClear( 
		GL_COLOR_BUFFER_BIT | 
		GL_DEPTH_BUFFER_BIT );
	
	return true;

}

// RendererOpenGL Draw
void RendererOpenGL::RenderEnd( void )
{

	// Draw End Process


}

// RendererDX9 Present Backbuffer
void RendererOpenGL::Present( void )
{
	
	// RendererDX9 Present Backbuffer
	
	// Swap Back to Front
	SwapBuffers( hDC );

}

// RendererDX9 GetDeviceInfo
HGLRC RendererOpenGL::GetDevice( void )
{
	
	// RendererDX9 GetDeviceInfo
	return hGLRC;
	
}

// RendererDX9 SetRenderState
void RendererOpenGL::RenderState( int* stateArray, bool* flaglist, int dataNumber )
{

	for( int index = 0; index < dataNumber; index++ ){
		if(flaglist[index]){
			glEnable( stateArray[index] );
		}else{
			glDisable( stateArray[index] );
		}
	}

}
