/***************************************************************/
//
//
//		DirectX	[ renderingordermanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			renderingordermanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "rendering_order_manager.h"

#include "rendering_orderdx9.h"
//#include "rendering_orderGL.h

#include "renderer.h"
#include "game_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/



/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

RenderingOrder* RenderingOrderManager::pOrder = nullptr;




// RenderingOrderManager Constructor
RenderingOrderManager::RenderingOrderManager( )
{
	// Member Clear Process
}

// RenderingOrderManager Destructor
RenderingOrderManager::~RenderingOrderManager( )
{
	// Do Nothing!!
}

// RenderingOrderManager Create Instance 
RenderingOrder* RenderingOrderManager::Setup( void )
{

	
	RenderingOrder* pCall = nullptr;
	
	// Confirm Platform
	Renderer::TYPE type = GameManager::PlatformInfo( );
	
	// Platform Select
	switch( type ){
	
	case  Renderer::RENDERER_DX9:
		pCall = RenderingOrderDX9::Create( ); 
		break;
		
	case  Renderer::RENDERER_GL:
		//pCall = RenderingOrderGL::Create( ); 
		break;

	default:
		break;
	}
	
	return pCall;

}

// RenderingOrder Release
void RenderingOrderManager::Release( void )	
{

	// Release < RenderingOrder >
	SAFE_DELETE( pOrder )

}

// RenderingOrderManager Registry Instance
void RenderingOrderManager::Registry( RenderingOrder* order )
{

	// Registry Instance
	pOrder = order;

}



