/***************************************************************/
//
//
//		DirectX	[ renderingordergl.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			Create Header File -> renderingordergl.h.h 
 			< Add Class Function >
				RenderingOrderGL->Constructor
				RenderingOrderGL->Destructor
				RenderingOrderGL->Create ( static member )
				RenderingOrderGL->Init
				RenderingOrderGL->Uninit
				RenderingOrderGL->Update
				RenderingOrderGL->Draw

Update : 2017/6/19



/*-------------------------------------------------------------*/
#ifndef _RENDERINGORDERGL_H_

#define _RENDERINGORDERGL_H_



/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "rendering_order.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class RenderingOrderGL Using RenderingOrderGL
class RenderingOrderGL: public RenderingOrder
{
public:
	
	RenderingOrderGL( );						// RenderingOrderGL Constructor
	~RenderingOrderGL( );						// RenderingOrderGL Destructor

	static RenderingOrderGL* Create( void );	// RenderingOrderGL Create Instance Class

	void DrawPrimitiveStrip(					// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	void DrawPrimitiveList(						// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	void DrawPrimitiveFan(						// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	void DrawSubset( 							// RenderingOrder DrawSubset
		ModelInterface* pMeshObj,
		Matrix* mtx = nullptr );		
	
	void DrawIndexPrimitive( 					// RenderingOrder DrawIndexPrimitive
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	// for Ortho Coord
	void DrawSprite(
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr );

	void DrawSpriteEx(
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture = nullptr );

private:

	// Member Variable


};

#endif	//	_RENDERINGORDERGL_H_


