/***************************************************************/
//
//
//		DirectX	[ screentransition.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			screentransition.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "system_component.h"

#include "screen_transition.h"

#include "scene_manager.h"
#include "swap_effect.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/



/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

ScreenTransition* ScreenTransition::instance = nullptr;



// ScreenTransition Constructor
ScreenTransition::ScreenTransition( )
	: swapEffect(nullptr)
	, next(nullptr)
	, state(TRANSITION_END)
{

	// Member Clear Process
	instance = this;

}

// ScreenTransition Destructor
ScreenTransition::~ScreenTransition( )
{

	// Do Nothing!!

}

// ScreenTransition Create Instance 
ScreenTransition* ScreenTransition::Create( void )
{

	// Create Class Instance
	return new ScreenTransition;

}

// ScreenTransition Release
void ScreenTransition::Release( void )
{
	
	if( swapEffect ){
		swapEffect->Uninit();
		delete swapEffect;
		swapEffect = nullptr;
	}
	delete instance;

}

// ScreenTransition TransitionProcess
void ScreenTransition::Update( void )
{

	if( state == NOTHING ){
		return;
	}
	else if( state == DO_TRANSITION ){
	
		swapEffect->DoTransition();
	}
	else if( state == SWITCH ){
	
		if(swapEffect->Switch())
			SceneManager::ChangeScene(next);
	}
	else if( state == TRANSITION_END ){
	
		swapEffect->TransitionEnd();
	}

	swapEffect->Update();


	
}

// ScreenTransition RegistrySwapEffect
void ScreenTransition::RegistrySwapEffect( SwapEffect* swapEffect )
{
	if( instance->swapEffect ){
		swapEffect->Uninit();
		delete swapEffect;
		swapEffect = nullptr;
	}
	instance->swapEffect = swapEffect;

}
	
// ScreenTransition use flag Change
void ScreenTransition::Transition( STATE state, Scene* next )
{

	instance->state = state;
	
	if( next )
		instance->next = next;

}





