/***************************************************************/
//
//
//		DirectX	[ spriteinterfacemanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/15
/*---------------------------------------------------------------
Update : 2017/6/15
			Create Header File -> spriteinterfacemanager.h.h 
 			< Add Class Function >
				SpriteInterfaceManager->Constructor
				SpriteInterfaceManager->Destructor
				SpriteInterfaceManager->Create ( static member )
				SpriteInterfaceManager->Init
				SpriteInterfaceManager->Uninit
				SpriteInterfaceManager->Update
				SpriteInterfaceManager->Draw

Update : 2017/6/15



/*-------------------------------------------------------------*/
#ifndef _SPRITEINTERFACEMANAGER_H_

#define _SPRITEINTERFACEMANAGER_H_



/*---------------------------------------------------------------
	Include File + other
---------------------------------------------------------------*/

#include <vector>

class SpriteInterface;

#define SPRITE_PRIORITY_NUMBER (8)

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class SpriteInterfaceManager Using SpriteInterfaceManager
class SpriteInterfaceManager
{
public:
	
	SpriteInterfaceManager( );						// SpriteInterfaceManager Constructor
	~SpriteInterfaceManager( );						// SpriteInterfaceManager Destructor

	static SpriteInterfaceManager* Create( void );	// SpriteInterfaceManager Create Instance Class

	static void Registry(							// SpriteInterfaceManager Registry
		SpriteInterface* data,
		const int priority );

	static void Delete(								// SpriteInterfaceManager Delete
		const SpriteInterface* object );

	static void Release( void );					// SpriteInterfaceManager Release
	static void Render( void );						// SpriteInterfaceManager Render
	
	void Destory( void );							// SpriteInterfaceManager Destory


private:

	// Member Variable
	std::vector<SpriteInterface*> data[SPRITE_PRIORITY_NUMBER];
	
	static SpriteInterfaceManager* pManager;


};


#endif	//	_SPRITEINTERFACEMANAGER_H_


