// Scene Script
#ifndef _GAME_SCENE_TEAMLOGO_H_
#define _GAME_SCENE_TEAMLOGO_H_


#include "system_component.h"
#include "scene.h"

#include "sprite.h"
#include "k_title.h"


#define START_LOGO_DERAY (60)

// namespace package GameScene
namespace GameScene{
	
	
	// Class Main Using SampleScene
	class TeamLogo : public Scene
	{
	private:

		// Member Variable
		int frame;
		bool frag;
		Sprite* logo;
		
	public:

		TeamLogo():frame(0),frag(false),logo(nullptr){}
		
		// Initialize Method
		void Init( void ) override{
			
		}
		
		// Uninitialize Method
		void Uninit( void ) override{
			logo->Uninit();
			SAFE_DELETE(logo)
		}
		
		// Update Method
		void Update( void ) override{
		

			frame++;

			if( frame == START_LOGO_DERAY ){
			
				frag = true;				
				logo = Sprite::Create( "data\\movie\\logo.avi" );
				logo->Init();

			}
			if( frag ){
				frag = false;
			}

			logo->Update();

			if( frame == (START_LOGO_DERAY + 90) )
				ScreenTransition::Transition( ScreenTransition::DO_TRANSITION, new KTitle );
				frag = true;

		}

	};
	
};



#endif	//	_GAME_SCENE_TEAMLOGO_H_


