/***************************************************************/
//
//
//		DirectX	[ texturemanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/17
/*---------------------------------------------------------------
Update : 2017/5/17
			texturemanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#define _CRT_SECURE_NO_WARNINGS

#include "texture_manager.h"

#include "texturedx9_interface.h"
#include "texturegl_interface.h"

#include "renderer.h"
#include "game_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	static member variable Initialize 
---------------------------------------------------------------*/

Resource<TextureInterface*> TextureManager::resource;



// TextureManager Constructor
TextureManager::TextureManager( )
{

	// Menber Clear Process

}

// TextureManager Destructor
TextureManager::~TextureManager( )
{

	// Do Nothing!!

}

// TextureManager Create Instance
TextureManager* TextureManager::Create( void )
{

	// Create Class Instance
	return new TextureManager;

}

// TextureManager LoadFromManager
TextureInterface* TextureManager::LoadFromManager( const char* FILE_NAME )
{

	TextureInterface* pTexture = nullptr;
	if( !(pTexture = TextureManager::Bind( FILE_NAME )) ){
		TextureManager::Load( FILE_NAME );
		pTexture = TextureManager::Bind( FILE_NAME );
	}

	return pTexture;
}

// TextureManager Directory Search
void TextureManager::SearchLoadDirectory( void )
{

	char path[256]    = {}; 

	// Get < Client Absolute Path >
	GetModuleFileName( NULL, path, MAX_PATH );

	// Synthesys Command Order
	char command[256] = {};
	char drive[256] = {};
	char dir[256] = {};
	char filename[256] = {};
	char extension[256] = {};
	char search[256] = {"data\\texture"};

	_splitpath( path, drive, dir, filename, extension );

	sprintf( filename, "%s.txt", filename );

	// Create output file
	sprintf( command, "dir %s%s%s >> %s", drive, dir, search, filename );
	system( command );

	// File Process
	FILE* pfile;

	if( !(pfile = fopen( filename, "rt" )) ){
		fclose(pfile);
		//return nullptr;

	}else{

		// t@CTCY擾
		fseek( pfile, 0, SEEK_END );
		unsigned int size = ftell( pfile );						// t@CTCY擾
		fseek( pfile, 0, SEEK_SET );

		// obt@m
		char* buf = new char[ size ]; 

		// t@Cǂݍ
		fread( buf, size, 1, pfile );
		fclose(pfile);
		delete[] buf;
		//return buf;
	}


	// Delete output file
	sprintf( command, "del /q  %s", filename );
	system( command );


}

// TextureManager Load Texture
bool TextureManager::Load( const char* FILE_NAME )
{
	

	// Confirm Platform
	Renderer::TYPE type = GameManager::PlatformInfo( );
			
	switch( type ){
			
	case  Renderer::RENDERER_DX9:{
				
		TextureInterface* pTexture = TextureDX9Interface::Create( );
		if( pTexture->Load( FILE_NAME )){
			resource.Registry( FILE_NAME, pTexture );
		}

		return true;
		}break;
										 
	case  Renderer::RENDERER_GL:{

		//data[index].texture
		TextureInterface* pTexture = TextureGLInterface::Create( );
		if( pTexture->Load( FILE_NAME ) ){
			resource.Registry( FILE_NAME, pTexture );
		}

		return true;
		}break;

	default:
		break;
	}
	
	return false;
	
}

// TextureManager Bind Texture
TextureInterface* TextureManager::Bind( const char* FILE_NAME )
{
	
	// bind - Model Data
	return resource.Export(FILE_NAME);

}
 
// TextureManager UnloadAll
void TextureManager::UnloadAll( void )
{

	// resource data -> Release
	resource.Delete( );

}

// TextureManager Release
void TextureManager::Release( TextureInterface* data )
{

	resource.Release(data);
	SAFE_DELETE(data)

}



