/***************************************************************/
//
//
//		DirectX	[ texturemanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/17
/*---------------------------------------------------------------
Update : 2017/5/17
			Create Header File -> texturemanager.h.h 
 			< Add Class Function >
				CTEXTUREMANAGER->Constructor
				CTEXTUREMANAGER->Destructor
				CTEXTUREMANAGER->Create ( static member )
				CTEXTUREMANAGER->Init
				CTEXTUREMANAGER->Uninit
				CTEXTUREMANAGER->Update
				CTEXTUREMANAGER->Draw

Update : 2017/5/17



/*-------------------------------------------------------------*/
#ifndef _TEXTUREMANAGER_H_

#define _TEXTUREMANAGER_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "texture_interface.h"

#include "resource_data.h"


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class TextureManager Using TextureManager
class TextureManager
{
public:
	
	TextureManager( );							// TextureManager constructor
	~TextureManager( );							// TextureManager destructor

	static TextureManager* Create( void );		// TextureManager Create Instance Class

	static bool Load( const char* FILE_NAME );	// TextureManager File Load Process
	
	static TextureInterface* Bind(				// TextureManager Bind
		const char* FILE_NAME );

	static TextureInterface* LoadFromManager(	// TextureManager LoadFromManager
		const char* FILE_NAME );

	static void SearchLoadDirectory( void );	// TextureManager Directory Search

	static void UnloadAll( void );				// TextureManager UnloadAll	
		
	static void Release(						// TextureManager Release
		TextureInterface* data );

private:

	// Member Function
	static Resource<TextureInterface*> resource;



};


#endif	//	_TEXTUREMANAGER_H_


