/***************************************************************/
//
//
//		DirectX	[ textureglinterface.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/17
/*---------------------------------------------------------------
Update : 2017/5/17
			Create Header File -> textureglinterface.h.h 
 			< Add Class Function >
				CTEXTUREGLINTERFACE->Constructor
				CTEXTUREGLINTERFACE->Destructor
				CTEXTUREGLINTERFACE->Create ( static member )
				CTEXTUREGLINTERFACE->Init
				CTEXTUREGLINTERFACE->Uninit
				CTEXTUREGLINTERFACE->Update
				CTEXTUREGLINTERFACE->Draw

Update : 2017/5/17



/*-------------------------------------------------------------*/
#ifndef _TEXTUREGLINTERFACE_H_

#define _TEXTUREGLINTERFACE_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "texture_interface.h"

#include <string>

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class TextureGLInterface Using TextureGLInterface
struct TextureGLInterface : public TextureInterface
{
public:
	
	// Member Variable
	int data;									// Texture Index
	
public:
	
	TextureGLInterface( );						// TextureGLInterface constructor
	~TextureGLInterface( );						// TextureGLInterface destructor

	static TextureGLInterface* Create( void );	// TextureGLInterface Create Instance Class

	void Release( void );						// TextureGLInterface Release
	bool Load( const char* FILE_NAME );			// TextureGLInterface Load

	void SetTexture( void );					// TextureInterface SetTexture
	TextureInterface* LoadFromManager(			// TextureGLInterface Load From Manager
		const char* FILE_NAME );

	
	// Global Function Texture Load Method
	
	static unsigned int GLTextureLoadFromPng(	// TextureGLInterface Png Load
		const std::string& fileName );
	
	static unsigned int GLTextureLoadFromTga(	// TextureGLInterface Tga Load
		const std::string& fileName );


};


#endif	//	_TEXTUREGLINTERFACE_H_


