/***************************************************************/
//
//
//		Aus System	[ Vector2.h ]
//
//											Author	kazuki tanaka
//											Date	2017 4/24
/*---------------------------------------------------------------
Update : 2017/4/24
			Create Header File -> Vector2.h.h 
 			< Add Class Function >
				CVector2->Constructor
				CVector2->Destructor
				CVector2->Create ( static member )
				CVector2->Init
				CVector2->Uninit
				CVector2->Update
				CVector2->Draw

Update : 2017/4/24



/*-------------------------------------------------------------*/
#ifndef _VECTOR2_H_

#define _VECTOR2_H_

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CVector2 Using Vector2
typedef struct Vector2
{
	
public:

	// Member Function
	float x;
	float y;
	
public:
	
	Vector2( );										// Vector2 constructor
	~Vector2( );									// Vector2 destructor

	// Member Method
	float Length( void ) const;						// Vector2 Length
	float Distance( const Vector2& other ) const;	// Vector2 Distance
	Vector2 Normalize( void ) const;				// Vector2 Normalize
	Vector2 Cross( const Vector2& other ) const;	// Vector2 Cross
	float Dot( const Vector2& other ) const;		// Vector2 Dot
	float Angle( Vector2& other );					// Vector2 Angle
	
    Vector2( const float * );
    Vector2( const Vector2& );
    Vector2( float x, float y );

    // casting
    operator float* ();
    operator const float* () const;

    // assignment operators
    Vector2& operator += ( const Vector2& other )
	{
	 	x += other.x;
		y += other.y;
		return *this;
	}
	
    Vector2& operator -= ( const Vector2& other )
	{
	 	x -= other.x;
		y -= other.y;
		return *this;
	}
	
    Vector2& operator *= ( const float ref )
	{
	 	x *= ref;
		y *= ref;
		return *this;
	}
	
    Vector2& operator /= ( const float ref )
	{
	 	x /= ref;
		y /= ref;
		return *this;
	}

    // unary operators
    Vector2 operator + () const
	{
		return Vector2( x, y );
	}
	
    Vector2 operator - () const
	{
		return Vector2( -x, -y );
	}
	
    // binary operators	
	Vector2 operator +( const Vector2& other ) const
	{
		return Vector2( x + other.x, y + other.y );
	}
	
	Vector2 operator -( const Vector2& other ) const
	{
		return Vector2( x - other.x, y - other.y );
	}
	
	Vector2 operator *( const float& ref ) const
	{
		return Vector2( x * ref, y * ref );
	}
	
	Vector2 operator /( const float& ref ) const
	{
		return Vector2( x / ref, y / ref );
	}

    //friend D3DXVector2 operator * ( float, const struct Vector2& );

    bool operator == ( const Vector2& other ) const
	{
		if( x == other.x && y == other.y )
			return true;
		else
			return false;
	}
	
    bool operator != ( const Vector2& other ) const
	{
		if( x != other.x || y != other.y )
			return true;
		else
			return false;
	}

	bool operator < ( const Vector2& other ) const
	{
		if( Length() < other.Length( ) )
			return true;
		return false;
	}
	
	bool operator > ( const Vector2& other ) const
	{
		if( Length() > other.Length( ) )
			return true;
		return false;
	}

	bool operator <= ( const Vector2& other ) const
	{
		if( Length() <= other.Length( ) )
			return true;
		return false;
	}
	
	bool operator >= ( const Vector2& other ) const
	{
		if( Length() >= other.Length( ) )
			return true;
		return false;
	}


}Vector2;


#endif	//	_VECTOR2_H_


