/***************************************************************/
//
//
//		DirectX	[ videorenderer.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/5
/*---------------------------------------------------------------
Update : 2017/5/5
			Create Header File -> videorenderer.h.h 
 			< Add Class Function >
				CVideoRenderer->Constructor
				CVideoRenderer->Destructor
				CVideoRenderer->Create ( static member )
				CVideoRenderer->Access ( static member )
				CVideoRenderer->Init
				CVideoRenderer->Uninit
				CVideoRenderer->Update
				CVideoRenderer->ReleaseAll ( static member )
				CVideoRenderer->UpdateAll  ( static member )
				CVideoRenderer->DrawAll    ( static member )

Update : 2017/5/5



/*-------------------------------------------------------------*/
#ifndef _VIDEORENDERER_H_

#define _VIDEORENDERER_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <d3dx9.h>
#include <d3d9.h>

#include <d3dx9math.h>
#include <windows.h>
#include <mmsystem.h>
#include <d3d9types.h>
#include <tchar.h>
#include <strsafe.h>

#include "smartptr.h"

#include <streams.h>
#include <renbase.h>
#include <objbase.h>
#include <dshow.h>



/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define VIDEORENDERER_MAX (6)

/*---------------------------------------------------------------
	CLASS
---------------------------------------------------------------*/


// class CVideoRenderer Using VideoRenderer
class CVideoRenderer
{
public:
	CVideoRenderer( );											// CVideoRenderer constructor
	~CVideoRenderer( );											// CVideoRenderer destructor

	static HRESULT CreateRealtimeRenderTexture(					// CVideoRenderer Create Instance Class
		const char* SOURCE_FILE_NAME,
		LPDIRECT3DTEXTURE9* pTexture );	

	static void CheckStatusAll( void );							// CVideo Renderer Check Movie Status
	static void ReleaseAll( void );								// CVideoRenderer Class Release All 
	
	HRESULT InitDShowTextureRenderer(							// @: WCHAR FILE_NAME
		const LPCWSTR SOURCE_FILE_NAME,
		LPDIRECT3DTEXTURE9* pTexture );	
	void CheckMovieStatus( void );								// CheckMovieStatus: If the movie has ended, rewind to beginning 
	void CleanupDShow( void );									// CleanupDShow

private:

	// VideoRenderer Member 
	SmartPtr<IGraphBuilder>  pGraphBuilder;        				// GraphBuilder
	SmartPtr<IMediaControl>  pMediaControl;          			// Media Control
	SmartPtr<IMediaPosition> pMediaPos;			    			// Media Position
	SmartPtr<IMediaEvent>    pMediaEvent;						// Media Event
	SmartPtr<IBaseFilter>    pRenderer;							// our custom renderer


	// static Member
	static CVideoRenderer* pVideoRenderer[ VIDEORENDERER_MAX ];	// video renderer


};


#endif	//	_VIDEORENDERER_H_


