/***************************************************************/
//
//
//		DirectX	[ currentframe.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/25
/*---------------------------------------------------------------
Update : 2017/6/25
			Create Header File -> currentframe.h.h 
 			< Add Class Function >
				CURRENTFRAME->Constructor
				CURRENTFRAME->Destructor
				CURRENTFRAME->Create ( static member )
				CURRENTFRAME->Init
				CURRENTFRAME->Uninit
				CURRENTFRAME->Update
				CURRENTFRAME->Draw

Update : 2017/6/25



/*-------------------------------------------------------------*/
#ifndef _CURRENTFRAME_H_

#define _CURRENTFRAME_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "userinterface.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class CurrentFrame Using CurrentFrame
class CurrentFrame : public UserInterface
{
public:
	
	CurrentFrame(						// UserInterface Constructor
		const std::string& filename,
		const float& vertical = 0.5f,
		const float& horizonal = 0.5f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,1.0f),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	
	~CurrentFrame( );					// UserInterface Destructor

	static CurrentFrame* Create(		// UserInterface Create Instance Class
		const std::string& filename,
		const float& vertical = 0.5f,
		const float& horizonal = 0.5f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,1.0f),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	

	void Init( void );						// CurrentFrame Initialize
	void Uninit( void );					// CurrentFrame Uninitialize
	void Update( void );					// CurrentFrame Update

	void ChangeTexture( 
		const std::string& filename );


private:

	// Member Variable


};


#endif	//	_CURRENTFRAME_H_


