/***************************************************************/
//
//
//		DirectX	[ debugfont.h ]
//
//											Author	kazuki tanaka
//											Date	2017 1/31
/*---------------------------------------------------------------
Update : 2017/1/31
			Create Header File -> debugfont.h
			

Update : 2016/1/31



/*-------------------------------------------------------------*/
#ifndef _DEBUGFONT_H_

#define _DEBUGFONT_H_


/*---------------------------------------------------------------
 	Macro Definition
---------------------------------------------------------------*/

#define CDF_MAX    (   1)						// Class Debug Font Max Number
#define STRING_MAX (1024)						// Font Data Max Number

/*---------------------------------------------------------------
	enum struct Render Position
---------------------------------------------------------------*/
 
/*
   --   DrawText() Format Flags  ---
#define DT_TOP                      0x00000000
#define DT_LEFT                     0x00000000
#define DT_CENTER                   0x00000001
#define DT_RIGHT                    0x00000002
#define DT_VCENTER                  0x00000004
#define DT_BOTTOM                   0x00000008
#define DT_WORDBREAK                0x00000010
#define DT_SINGLELINE               0x00000020
#define DT_EXPANDTABS               0x00000040
#define DT_TABSTOP                  0x00000080
#define DT_NOCLIP                   0x00000100
#define DT_EXTERNALLEADING          0x00000200
#define DT_CALCRECT                 0x00000400
#define DT_NOPREFIX                 0x00000800
#define DT_INTERNAL                 0x00001000
*/


// enum struct Render Position
typedef enum{
	L_RENDER = 0x00000000,	// DT_LEFT
	R_RENDER = 0x00000002,	// DT_RIGHT
	C_RENDER = 0x00000001,	// DT_CENTER | DT_VCENTER
}DF_RENDER_POS;

#include "rendererdx9.h"

/*---------------------------------------------------------------
	Class CDebugfont for Screen Render Debug Font
---------------------------------------------------------------*/

// Screen Font For Debug
class CDebugFont
{	
public:

	CDebugFont( );								// CDebugFont constructor
	~CDebugFont( );								// CDebugFont destructor
	
	static CDebugFont* SetDebugFont( void );	// CDebugFont SetDebugFont Setting
	static CDebugFont* Access(					// CDebugFont Get Pointer
		const int index = 0 );						

	CDebugFont* Release( void );				// CDebugFont Class Release
	void SetRenderData( 						// CDebugFont Render Data Set
		DF_RENDER_POS renderType,
		char* data, ... );
	void Render( void );						// CDebugFont Data Render
	void SetColor( const LPD3DXCOLOR color );	// CDebugFont Set Font Color
	
	static void ReleaseAll( void );				// CDebugFont Release Class All
	static void DrawAll( void );				// CDebugFont Draw Class All

	static void DebugCenterRender(				// CDebugFont Render Center Flag Switch
		const bool flag );
	
	void Clear(void);


private:

	LPD3DXFONT pFont;							// Font Device Interface pointer
	D3DXCOLOR  color;							// Font Color
	char lData[ STRING_MAX ];					// Left Render Data
	char rData[ STRING_MAX ];					// Right Render Data
	char cData[ STRING_MAX ];					// Center Render Data
	int        myNumber;						// Class ID : My Number 
	
	static CDebugFont* pDebugFont[ CDF_MAX ];	// Class Registry Debug Font
	static bool centerRender;					// Render Center flag
	
};




#endif	//	_DEBUGFONT_H_


