/***************************************************************/
//
//
//		DirectX	[ debuglog.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/6
/*---------------------------------------------------------------
Update : 2017/1/6
			debuglog.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include <stdio.h>
#include <Windows.h>
#include "window.h"
#include "d_log.h"
#include "d_console.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

/*----------------------------------------------------------------
	X^eBbNoϐ̏
----------------------------------------------------------------*/

std::map<std::string,ApplicationLog*> ApplicationLog::data;


// RXgN^
ApplicationLog::ApplicationLog()
	: filename()
	, pfile(nullptr)
{



}

// fXgN^
ApplicationLog::~ApplicationLog()
{


}

// Ot@C݂̊Jn
ApplicationLog* ApplicationLog::BeginLog( const std::string& filename )
{

	ApplicationLog* log = new ApplicationLog;

	// Registry Instance
	//data[filename] = log;

	// t@C̎擾
	if( filename.data() ){
		log->filename = filename;
	}

	// t@CI[v
	log->pfile = fopen( log->filename.data() , "w" );
	if( !log->pfile ){

		#ifdef _DEBUG
		MessageBox(NULL, "TXT LOAD ERROR !!", APPLICATION_NAME, MB_OK | MB_ICONINFORMATION );
		#endif	// _DEBUG
		return nullptr;
	}
	
	return log;

}

// t@CN[Y
void ApplicationLog::EndLog( void )
{

	// t@CN[Y
	fclose( pfile );
	pfile = NULL;

}

// fobȌo
void ApplicationLog::WriteLog( char* fmt, ... )
{

	if( pfile == NULL ){
		return;
	}

	// ϒz
	va_list ap;
	char buf[ 256 ];
	bool flag = false;
	DWORD word;
	
	// ϒf[^̎擾
	va_start( ap, fmt );

	// obt@փf[^
	vsprintf( buf, fmt, ap );
	
	// I
	va_end( ap );
	
	// t@C
	fprintf( pfile, buf );

}

// O̕\
void ApplicationLog::ShowLog( void )
{

	bool key = false;

	// Confirm File lock
	if( pfile ){

		// fileClose
		ApplicationLog::EndLog( );
		key = true;
	}

	// show LogFile
	if( filename.data() ){

		system( filename.data() );
	}

	// key|ĂꍇAČ
	if( key ){
	
		// fileopen
		pfile = fopen( filename.data() , "a+" );
		if( !pfile ){

			#ifdef _DEBUG
			MessageBox(NULL, "TXT LOAD ERROR !!", APPLICATION_NAME, MB_OK | MB_ICONINFORMATION );
			#endif	// _DEBUG
		}
	}

}

// DebugLog OutputConsole
void ApplicationLog::OutputConsole( void )
{

	bool key = false;

	// t@CbNĂ邩ǂmF
	if( pfile ){

		// t@CN[Y
		ApplicationLog::EndLog( );
		key = true;
	}

	// Ot@C̕\
	if( filename.data() ){

		system( filename.data() );
	}

	// key|ĂꍇAČ
	if( key ){
	
		// t@CI[v
		pfile = fopen( filename.data() , "a+" );
		if( !pfile ){

			#ifdef _DEBUG
			MessageBox(NULL, "TXT LOAD ERROR !!", __FILE__, MB_OK | MB_ICONINFORMATION );
			#endif	// _DEBUG
		}
	}

	// f[^i[p
	char* txtData;

	// t@CTCY擾
	fseek( pfile, 0, SEEK_END );
	unsigned int size = ftell( pfile );	
	fseek( pfile, 0, SEEK_SET );

	// obt@m
	txtData = new char[ size ]; 

	// t@Cǂݍ
	fread( txtData, size, 1, pfile );

	Console::DebugLog("Log : \n%s", txtData );

	delete txtData;



}


