/***************************************************************/
//
//
//		DirectX	[ Event.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/31
/*---------------------------------------------------------------
Update : 2017/1/31
			Create CPP -> Event.cpp

/*---------------------------------------------------------------
	include File
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include <stdio.h>
#include "event.h"

#include <Windows.h>
#include "game_manager.h"

#ifdef _DEBUG
//#include "d_font.h"
#endif // _DEBUG

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

/*----------------------------------------------------------------
	static member variable Initialize
----------------------------------------------------------------*/

CEvent* CEvent::pEvent[ MAX_EVENT ] = { };
bool    CEvent::events        = false;
int     CEvent::callbackIndex = 0;



// CEvent constructor
CEvent::CEvent( )
{

	// Member Initialize
	char buf[ STRING_MAX ] = {};
	strcpy( eventName, buf );

	// Registration Class( Texture Renderer )
	for( int index = 0; index < MAX_EVENT; index++ ){
		if( pEvent[index] == NULL ){
			pEvent[index] = this;
			myNumber = index;
			break;
		}
	}


}

// CEvent destructor
CEvent::~CEvent( )
{

    // Do Nothing!!

}

// CEvent Release Class All
void CEvent::ReleaseAll( void )
{

	// Release CEvent All
	for( int index = 0; index < MAX_EVENT; index ++ ){

		if( pEvent[ index ] ){
		
			pEvent[ index ] ->Uninit( );
			SAFE_DELETE( pEvent[ index ] )
		}
	}


}

// CEvent Update Class All
void CEvent::CallbackUpdate( void )
{

	// Update CEvent All
	pEvent[ callbackIndex ] ->Update( );

}

// CEvent Draw Class All
void CEvent::CallbackDraw( void )
{

	// Draw CEvent All
	pEvent[ callbackIndex ] ->Draw( );


}

// CEvent Callback Setting Do Event
bool CEvent::CallbackEvent( const char* EVENT_NAME )
{

	// Search Event
	for( int index = 0; index < MAX_EVENT; index ++ ){

		if( pEvent[index] != NULL ){
			if( strcmp( pEvent[index]->eventName, EVENT_NAME ) == 0 ){
		
				callbackIndex = index;
				events = true;
				return true;
			}
		}
	}
	
	return false;
	
}

// CEvent Events True Or False
bool CEvent::EventsState( void )
{

	// Get eventsState
	return events;

}

// Setting Event Name
void CEvent::SetEventName( const char* EVENT_NAME )
{
	strcpy( eventName, EVENT_NAME );
}



