// Scene Script
#ifndef _GAME_H_
#define _GAME_H_


#include "system_component.h"
#include "scene.h"

#include "camera.h"
#include "meshfield.h"
#include "light.h"
#include "photo.h"

#include "fieldmap.h"

#include "particle.h"
#include "explosion.h"

#include "model.h"
#include "immortal.h"

#include "pause_manager.h"
#include "pause.h"

#include "score_frame.h"

#define SET_GAME (2)

#define STAGE_MAX (5) 



// namespace package GameScene
namespace GameScene{
	
	// Class SampleScene Using SampleScene
	class Game : public Scene
	{
	private:

		// Member Variable
		MeshField* meshField;
		FieldMap*  map;

		UserInterface* stageName;
		UserInterface* hotateFrame;

		Base* object[NUM_OBJECT];

		int number;

		static const char* STAGE_NAME[STAGE_MAX];
		static const char* FRAME_NAME[STAGE_MAX];
		
	public:

		Game( const int number ):meshField(nullptr),map(nullptr),stageName(nullptr),hotateFrame(nullptr)
		{
			Game::number = number;

			for( int index = 0; index < NUM_OBJECT; index++ )
				object[index] = nullptr;
		}
		
		// Initialize Method
		void Init( void ) override{
		
			// Member Clear Process
			map = FieldMap::Create( );
			map->Init( STAGE_NAME[number] );

			// Initialize Process
			meshField = MeshField::Create( );
			meshField->Init( );

			CPhoto::Create("effect")->Init();
			Camera::PlatformInstance("mainCamera");
			Camera::Access()->Init();

			CLight::Create( "Directional" );

			stageName = UserInterface::Create( FRAME_NAME[number],0.38,0.11,Color(1,1,1,1),Vector3(-0.705,0.52,1));
			stageName->Init();

			hotateFrame = UserInterface::Create( "data\\TEXTURE\\frame.png",0.16,0.09,Color(1,1,1,1),Vector3(0.624999,0.52,1));
			hotateFrame->Init();											

			InitParticle();
			InitExplosion();
			InitScoreFrame();

			CPauseManager::Create( "pause" )->Init( );

			// ̐ݒu
			object[0] = Model::Instance<Immortal>( 
				"data\\MODEL\\ship.x",								// f
				Vector3( -90,30,5),
				Vector3( 0,80,0),
				Vector3( 3,3,3));	// W(3)
			object[0]->Init();
			
			object[1] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x" ,								// f
				Vector3( 70,30,70),
				Vector3( 0,0,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[1]->Init();

			object[2] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( 60,30,50),
				Vector3( 0,20,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[2]->Init();

			
			object[3] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x" ,								// f
				Vector3( 90,30,10),
				Vector3( 0,40,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[3]->Init();

			object[4] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( -70,30,70),
				Vector3( 0,80,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[4]->Init();

			object[5] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( -90,30,-20),
				Vector3( 0,80,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[5]->Init();

			object[6] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( -50,30,90),
				Vector3( 0,80,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[6]->Init();

			object[7] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( -80,30,-60),
				Vector3( 0,80,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[7]->Init();

			object[8] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( -80,30,90),
				Vector3( 0,80,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[8]->Init();

			object[9] = Model::Instance<Immortal>( 
				"data\\MODEL\\sango.x",								// f
				Vector3( 45,180,-45),
				Vector3( 0,80,0),
				Vector3( 0.14,0.14,0.14));	// W(3)
			object[9]->Init();
			
		}
		
		// Uninitialize Method
		void Uninit( void ) override{
		
			// Uninitialize Process
			meshField->Uninit();
			delete meshField;

			map->Uninit();

			for( int index = 0; index < NUM_OBJECT; index++ ){
				if( object[index] ){
					object[index]->Uninit();
					//SAFE_DELETE(object[index])
				}
			}

			stageName->Uninit();
			hotateFrame->Uninit();

			UninitParticle();
			UninitExplosion();
			UninitScoreFrame();

			CLight::ReleaseAll( );
			Camera::ReleaseAll( );
			CPhoto::ReleaseAll( );

		}
		
		// Update Method
		void Update( void ) override{
		
			meshField->Update( );

			map->Update();

			for( int index = 0; index < NUM_OBJECT; index++ ){
				if( object[index] ){
					object[index]->Update();
				}
			}

			stageName->Update();
			hotateFrame->Update();

			UpdateParticle();
			UpdateExplosion();
			UpdateScoreFrame();

			// |[Y
			if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_BACK ) ){
	
				SetEnablePause( true );
				CEvent::CallbackEvent( "pause" );
			}

			CPhoto::Access()->SetPhoto();
		}

		void Draw( void ) override{
		
			DrawParticle();
			DrawScoreFrame();

			if( CEvent::EventsState( )){
				CEvent::CallbackDraw( );
			}
		}

	};
	
};


#endif	//	_GAME_H_


