/***************************************************************/
//
//
//		DirectX	[ gamemanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/11
/*---------------------------------------------------------------
Update : 2017/5/11
			gamemanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "window.h"
#include "game_manager.h"

// for Graphic Library
#include "renderer_manager.h"
#include "renderer.h"

// for Input system
#include "input.h"
#include "keyboard.h"
#include "mouse.h"
#include "gamepad.h"

// for
#include "system_pipeline.h"

// for debug 
#include "d_manager.h"
#include "d_font.h"
#include "d_log.h"
#include "d_console.h"



/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

GameManager* GameManager::pManager = nullptr;





// GameManager Constructor
GameManager::GameManager( )
	: pRendererManager( nullptr )
	, gameMaster( nullptr )
	, pipeline(nullptr)
{

	// Menber Clear Process
	if( !pManager ){
		pManager = this;
	}

}

// GameManager Destructor
GameManager::~GameManager( )
{

	// Do Nothing!!

}

// GameManager Create Instance 
GameManager* GameManager::Create( void )
{

	// Create Class Instance
	return new GameManager;

}

// GameManager Initialize
void GameManager::Init( HWND hWnd, bool bWindow )
{

	// Initialize Process
	
	{ // Renderer Initialize
		
		pRendererManager = RendererManager::Create( Renderer::RENDERER_DX9 );	// DirectX9 Platform
		pRendererManager->Init( );
		pRendererManager->GetRenderer( )->Init( hWnd, bWindow );
		platform = pRendererManager->ConfirmRendererType( );
	}

	{ // Input COM Initialize

		// get [ HINSTANCE ]
		HINSTANCE hInstance = (HINSTANCE)GetWindowLong( hWnd, GWL_HINSTANCE );
		CInputKeyboard::Create( "keyboard" )->Init( hInstance, hWnd );
		InputMouse::Create( )->Init( hInstance, hWnd );
	}

	{ // Scene Manager Initialize

		pipeline = SystemPipeline::Create();
		pipeline->Init();
	}

	{ // DebugManager Initialize

		CDebugManager::Create( ) ->Init( );
		//Console::OpenConsole( );
	}



}

// GameManager Uninitialize
void GameManager::Uninit( void )
{

	{ // Scene Manager Uninialize

		pipeline->Uninit();
	}

	{ // Release Input
		CInput::ReleaseAll( );
	}

	{ // TEhfoCX
		//CModelManager::UnloadAll( );
		//CLight::ReleaseAll( );
	}

	{ // Release Debug Manager
		Console::CloseConsole( );
		CDebugManager::ReleaseAll( );
	}

	{ // Renderer Uninitialize
		pRendererManager->GetRenderer( )->Uninit( );
		pRendererManager->Uninit( );
		SAFE_DELETE( pRendererManager )
	}

	// GameManager Destory
	SAFE_DELETE( pManager )

}

// GameManager Update
void GameManager::Update( void )
{

	CDebugManager::IndexAccess(0) ->StartMeasureProcess( );

	// Update Process
	CInput::UpdateAll( );

	// Update Scene
	pipeline->Update();

	
	// Update Debug Manager
	#ifdef _DEBUG
	//Console::DebugLog( "WindowFPS : %d\n", Window::GetFPS( ) );
	CDebugManager::UpdateAll( );
	#endif // _DEBUG


}

// GameManager Draw
void GameManager::Draw( void )
{


	// Draw Process
	if( pRendererManager->GetRenderer( )->RenderBegin( ) ){
	
		// Render Scene 
		pipeline->Render();

		#ifdef _DEBUG
		CDebugManager::IndexAccess(0) ->EndMeasureProcess( );
		Vector2 screen = InputMouse::Access()->GetPosWorld();
		CDebugFont::Access()->SetRenderData( L_RENDER, " [ %s ] \n ALL PROCESS FPS : %d \n Mouse X:%f Y:%f Z:%d \n",  APPLICATION_NAME, Window::GetFPS( ), screen.x, screen.y, InputMouse::Access()->GetAxisZ() );
		CDebugFont::Access()->Render( );
		CDebugManager::DrawAll( );
		#endif // _DEBUG
		CDebugFont::Access()->Clear();

		pRendererManager->GetRenderer( )->RenderEnd( );
	}
	pRendererManager->GetRenderer( )->Present( ); 


}

// GameManager Operate
GameManager* GameManager::Operate( void )
{

	// GameManager Operate
	return pManager;

}
 
// GameManager GetRendererManager
RendererManager* GameManager::GetRendererManager( void )
{

	return pRendererManager;

}

// GameManager Device Info
Renderer* GameManager::DeviceInfo( void )
{

	// GameManager Device Info 
	return  pManager->GetRendererManager( )->GetRenderer( );

}

// GameManager Platform 
Renderer::TYPE& GameManager::PlatformInfo( void )
{

	// GameManager Platform 
	return pManager->platform;

}






