/***************************************************************/
//
//
//		DirectX	[ gameobjectmanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			gameobjectmanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "gameobject_manager.h"

#include "gameobject.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

GameObjectManager* GameObjectManager::manager = nullptr;



// GameObjectManager Constructor
GameObjectManager::GameObjectManager( )
	: data()
{

	// Member Clear Process
	if( manager ){
		manager->Uninit();
		delete manager;
	}
	manager = this;

}

// GameObjectManager Destructor
GameObjectManager::~GameObjectManager( )
{

	// Do Nothing!!

}

// GameObjectManager Create Instance 
GameObjectManager* GameObjectManager::Create( void )
{

	// Create Class Instance
	return new GameObjectManager;

}

// GameObjectManager Registry Instance
void GameObjectManager::Registry( GameObject* object )
{

	// Registry Instance
	manager->data.push_back(object);

}

// GameObjectManager Release Instance
void GameObjectManager::Release( GameObject* object )
{

	for( int index = 0; index < manager->data.size(); index++ ){

		if( manager->data[index] == object ){
			delete object;
			manager->data[index] = nullptr;
			manager->data.erase(manager->data.begin()+index);
		}
	}

}

// GameObjectManager Release Instance
void GameObjectManager::ReleaseAll( void )
{

	if(manager){
		manager->Uninit();
		delete manager;
	}

}

// GameObjectManager Get<GameObject Status>
std::vector<GameObject*> GameObjectManager::GetGameObject( void )
{

	return manager->data;

}

// GameObjectManager Uninitialize
void GameObjectManager::Uninit( void )
{

	// Uninitialize Process
	for( int index = data.size(); index > 0; index-- ){
	
		if( data[index-1] ){
			data[index-1]->Uninit();
			delete data[index-1];
		}
		data.pop_back();
	}

}

// GameObjectManager Update
void GameObjectManager::Update( void )
{

	// Update Process
	for( int index = manager->data.size(); index > 0; index-- ){
	
		manager->data[index-1]->Update();
	}

}




