/***************************************************************/
//
//
//		DirectX	[ grid.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/22
/*---------------------------------------------------------------
Update : 2017/6/22
			grid.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "grid.h"

#include "mesh_renderergrid.h"

#include "vertexbuffer_manager.h"
#include "vertexbuffer.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

#include "vertexbufferdx9.h"

#include "fieldmap.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// Grid Constructor
Grid::Grid( const Color& color, const int& vertical, const int& horizonal,  const int& size, const Matrix& mtx )
	: mtx(mtx)
	, color(color)
	, pVtxBuf(nullptr)
	, renderer(nullptr)
	, horizonal( horizonal )
	, vertical( vertical )
	, size( size )
{

	// Member Clear Process

}

// Grid Destructor
Grid::~Grid( )
{

	// Do Nothing!!

}

// Grid Create Instance 
Grid* Grid::Create( const Color& color, const int& vertical, const int& horizonal, const int& size, const Matrix& mtx )
{

	// Create Class Instance
	return new Grid( color, vertical, horizonal, size, mtx );

}

// Grid Initialize
void Grid::Init( void )
{

	// Initialize Process
	mtx = mtx.Identity();

	pVtxBuf = VertexBufferManager::PlatformSelect();
	if( !pVtxBuf->CreateVertexBuffer( GRID_FVF_FORMAT, (((horizonal+1)+(vertical+1)))*2, sizeof( GridVertex ) ) ) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( );

	// Component Set
	renderer = MeshRendererGrid::SetComponent( &pVtxBuf, &mtx );

}

// Grid Uninitialize
void Grid::Uninit( void )
{

	// Uninitialize Process
	pVtxBuf->Release();
	RenderInterfaceManager::Delete( renderer );

}

// Grid Update
void Grid::Update( void )
{

	// Update Process

}

// Grid SetBuffer
void Grid::SetBuffer( void )
{

	// Vertual Pointer
	GridVertex*      pVtx;

	Vector2 offset( -(size*vertical)*0.5f, size*horizonal*0.5f );

	
	{ // vertex buffer Setting

		pVtxBuf->Lock( &pVtx );

		int index = 0;
		
		for( int z = 0; z < horizonal+1; z++ ){

			pVtx[index].pos = Vector3( offset.x, MAP_HEIGHT,offset.y-size*z );
			pVtx[index++].color = color;

			pVtx[index].pos = Vector3( -offset.x,MAP_HEIGHT,offset.y-size*z );
			pVtx[index++].color = color;
		}

		for( int x = 0; x < vertical+1; x++  ){
				
			pVtx[index].pos = Vector3( offset.x+size*x,MAP_HEIGHT,offset.y );
			pVtx[index++].color = color;

			pVtx[index].pos = Vector3( offset.x+size*x,MAP_HEIGHT,-offset.y );
			pVtx[index++].color = color;
		}

		pVtxBuf->Unlock( );

	} // -> END

}

// Grid vertex SetColor
void Grid::SetColor( const Color& color )
{

	Grid::color = color;
	
	GridVertex*     pVtx;
	pVtxBuf->Lock( &pVtx );
	for( int index = 0; index < pVtxBuf->GetVertexNumber(); index++ ){
		pVtx[index].color = color;
	}
	pVtxBuf->Unlock( );

}

// Grid Lock
void Grid::Lock( GridVertex* pVtx )
{

	pVtxBuf->Lock( &pVtx );

}

// Grid Unlock
void Grid::Unlock( void )
{

	pVtxBuf->Unlock( );

}




