//=========================================================================
//	CTitleNX[ title.cpp ]
//	쐬F2017/06/05
//	쐬ҁF
//=========================================================================
//CN[ht@C
#include	"k_title.h"
#include	"k_field.h"
#include	"k_sumi.h"
#include	"k_tako.h"
#include	"k_hotate.h"

#include "system_pipeline.h"
#include "xboxcontroller.h"
#include "game.h"

#include "title.h"

//=========================================================================
//	RXgN^
//=========================================================================
KTitle::KTitle(  )
{
	frame = 0;
}

//=========================================================================
//	fXgN^
//=========================================================================
KTitle::~KTitle(  )
{

}

//=========================================================================
//	
//=========================================================================
void	KTitle::Init( void )
{

	//J̐
	camera = new KCamera;
	camera->Init();

	//̐ݒ
	light = new KLight;
	light->Init();

	m_pField = new KField();
	m_pField->Init();

	m_pSumi = new KSumi();
	m_pSumi->Init();

	m_pTako = new KTako();
	m_pTako->Init();

	m_pHotete0 = new KHotate();
	m_pHotete0->Init();
	m_pHotete0->SetPosition( D3DXVECTOR3( -200.0f , 0.0f , 0.0f ) );

	m_pHotete1 = new KHotate();
	m_pHotete1->Init();
	m_pHotete1->SetPosition( D3DXVECTOR3( 200.0f , 0.0f , 0.0f ) );

	SystemPipeline::SetCamera( 0 );

	cnt = 0;


}

//=========================================================================
//	I
//=========================================================================
void	KTitle::Uninit( void )
{
	if( m_pField != NULL )
	{
		m_pField->Uninit();
		delete m_pField;
		m_pField = NULL;
	}

	if( m_pSumi != NULL )
	{
		m_pSumi->Uninit();
		delete m_pSumi;
		m_pSumi = NULL;
	}

	if( m_pTako != NULL )
	{
		m_pTako->Uninit();
		delete	m_pTako;
		m_pTako = NULL;
	}

	if( m_pHotete0 != NULL )
	{
		m_pHotete0->Uninit();
		delete	m_pHotete0;
		m_pHotete0 = NULL;
	}

	if( m_pHotete1 != NULL )
	{
		m_pHotete1->Uninit();
		delete	m_pHotete1;
		m_pHotete1 = NULL;
	}

	//J̔j
	if( camera != NULL )
	{
		camera->Uninit();
		delete	camera;
		camera = NULL;
	}

	
	//̔j
	if( light != NULL )
	{
		light->Uninit();
		delete light;
		light = NULL;
	}

	
}

//=========================================================================
//	XV
//=========================================================================
void	KTitle::Update( void )
{
	// tB[h̍XVȂ̂ł
	// m_pField->Update();

	camera->Update();
	light->Update();


	if( m_pHotete0->GetPosition().x <= -10.0f )
	{
		m_pHotete0->Move( D3DXVECTOR3( 1.0f , 0.0f , 0.0f ) );
	}

	if( m_pHotete1->GetPosition().x >= 10.0f )
	{
		m_pHotete1->Move( D3DXVECTOR3( -1.0f , 0.0f , 0.0f ) );
	}
	else
	{
		m_pTako->Move( D3DXVECTOR3( 0.0f , 1.0f , 0.0f ) );	
		cnt++;
	}

	if( cnt == 1 )
	{
		for( int i = 0 ; i < 1000 ; i++ )
		{
			m_pSumi->SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 15.0f ) );
		}
	}
		 
	m_pSumi->Update();
	m_pTako->Update();
	m_pHotete0->Update();
	m_pHotete1->Update();

	if( frame == 240 ){
		ScreenTransition::Transition( ScreenTransition::DO_TRANSITION, new GameScene::Title );
	}

	frame++;
	
}

//=========================================================================
//	`揈
//=========================================================================
void	KTitle::Draw( void )
{

	camera->Set();

	m_pField->Draw();
	m_pTako->Draw();
	m_pHotete0->Draw();
	m_pHotete1->Draw();
	m_pSumi->Draw();
}

//=========================================================================
//	^CgNX̍쐬
//=========================================================================
KTitle*	KTitle::Create( void )
{
	KTitle*  pTitle;
	pTitle = new KTitle();
	pTitle->Init();

	return pTitle;
}