/***************************************************************/
//
//
//		DirectX	[ menulist.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/23
/*---------------------------------------------------------------
Update : 2017/6/23
			menulist.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/



#include "menulist.h"

#include "userinterface.h"
#include "system_component.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MenuList Constructor
MenuList::MenuList( 
	float percent, 
	float padding )				// MenuList Constructor
	: percent(percent)
	, padding(padding)
{

	// Member Clear Process

}

// MenuList Destructor
MenuList::~MenuList( )
{

	// Do Nothing!!

}

// MenuList Create Instance 
MenuList* MenuList::Create( 	
	float percent, 
	float padding )				// MenuList Constructor

{

	// Create Class Instance
	MenuList* pObject;
	pObject = new MenuList(percent,padding);

	return pObject;

}

// MenuList Initialize
void MenuList::Init( 
	const char* TEXTURE_NAME[ ],
	int number,
	const Vector2& texSize,
	const Vector2& offset,
	const Color& color,
	bool flag  )
{

	// Initialize Process
	MenuList::number = number;

	// Initialize Process
	menu = new UserInterface*[ number ];

	float texX = texSize.x;
	float texY = texSize.y;

	if( flag == 0 ){

		for( int index = 0; index < number; index++ ){
	
			float position = (percent/number)*index + (percent/number)*0.5f;
			float tHeight  = ((percent/number)-padding);
			float tWidth   = tHeight * (texX / texY);
			menu[ index ] = UserInterface::Create( TEXTURE_NAME[index], tWidth, tHeight, color, Vector3( offset.x, position - percent*0.5f-offset.y, 2.0f ) );
			menu[ index ]->Init( );
		}
	}
	else if( flag == 1 ){
	
		for( int index = 0; index < number; index++ ){
	
			float position = (percent/number)*index + (percent/number)*0.5f;
			float tWidth   = ((percent/number)-padding);
			float tHeight  = tWidth * (texY / texX);
			menu[ index ] = UserInterface::Create( TEXTURE_NAME[index], tWidth, tHeight, color, Vector3( position - percent*0.5f+offset.x, -offset.y, 2.0f ) );
			menu[ index ]->Init( );
		}
	}


}

// MenuList Uninitialize
void MenuList::Uninit( void )
{

	// Uninitialize Process
	for( int index = 0; index < number; index++ ){
	
		menu[ index ]->Uninit( );
	}
	
	SAFE_DELETE_ARRAY( menu )


}

// MenuList Update
void MenuList::Update( void )
{

	// Update Process
	for( int index = 0; index < number; index++ ){
	
		menu[ index ]->Update( );
	}
	

}







