/***************************************************************/
//
//
//		DirectX	[ meshrenderer3duserinterface.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/19
/*---------------------------------------------------------------
Update : 2017/6/19
			meshrenderer3duserinterface.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "mesh_renderer3duserinterface.h"

#include "texture_interface.h"
#include "vertexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshRenderer3DUserInterface Constructor
MeshRenderer3DUserInterface::MeshRenderer3DUserInterface( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx, const int priority )
	: RenderInterface(priority)
	, ppVtxBuf( ppVtxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Member Clear Process
	

}

// MeshRenderer3DUserInterface Destructor
MeshRenderer3DUserInterface::~MeshRenderer3DUserInterface( )
{

	// Do Nothing!!


}

// MeshRenderer3DUserInterface Create Instance 
MeshRenderer3DUserInterface* MeshRenderer3DUserInterface::SetComponent( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx, const int priority )
{

	// Create Class Instance
	return new MeshRenderer3DUserInterface( ppVtxBuf, ppTexture, pMtx, priority );

}

// MeshRenderer3DUserInterface Render
void MeshRenderer3DUserInterface::Render( void )
{

	// Render Process	
	RenderingOrderManager::Operate( )->Draw3DUserInterface( *ppVtxBuf, *ppTexture, pMtx );

}






