/***************************************************************/
//
//
//		System	[ meshrendereraddblendbillboard.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/28
/*---------------------------------------------------------------
Update : 2017/6/28
			meshrendereraddblendbillboard.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "mesh_rendereraddblendbillboard.h"


#include "texture_interface.h"
#include "vertexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshRendererAddBlendBillboard Constructor
MeshRendererAddBlendBillboard::MeshRendererAddBlendBillboard( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(5)
	, ppVtxBuf( ppVtxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Member Clear Process
	

}

// MeshRendererAddBlendBillboard Destructor
MeshRendererAddBlendBillboard::~MeshRendererAddBlendBillboard( )
{

	// Do Nothing!!

}

// MeshRendererAddBlendBillboard Create Instance 
MeshRendererAddBlendBillboard* MeshRendererAddBlendBillboard::SetComponent( VertexBuffer** ppVtxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRendererAddBlendBillboard( ppVtxBuf, ppTexture, pMtx );

}

// MeshRendererAddBlendBillboard Render
void MeshRendererAddBlendBillboard::Render( void )
{

	// Render Process	
	RenderingOrderManager::Operate( )->DrawBillboardAddBlend( *ppVtxBuf, *ppTexture, pMtx );

}








