/***************************************************************/
//
//
//		DirectX	[ meshrendererex.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/22
/*---------------------------------------------------------------
Update : 2017/5/22
			meshrendererex.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "mesh_rendererex.h"

#include "texture_interface.h"
#include "vertexbuffer.h"
#include "indexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// MeshRendererEX Constructor
MeshRendererEX::MeshRendererEX( VertexBuffer** ppVtxBuf, IndexBuffer** ppIdxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(3)
	, ppVtxBuf( ppVtxBuf )
	, ppIdxBuf( ppIdxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Menber Clear Process

}

// MeshRendererEX Destructor
MeshRendererEX::~MeshRendererEX( )
{

	// Do Nothing!!

}

// MeshRendererEX Create Instance 
MeshRendererEX* MeshRendererEX::SetComponent( VertexBuffer** ppVtxBuf, IndexBuffer** ppIdxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRendererEX( ppVtxBuf, ppIdxBuf, ppTexture, pMtx );

}

// MeshRendererEX Draw
void MeshRendererEX::Render( void )
{

	// Render Process
	RenderingOrderManager::Operate( )->DrawIndexPrimitive( *ppVtxBuf, *ppIdxBuf, *ppTexture, pMtx );

}





