/***************************************************************/
//
//
//		DirectX	[ meshrendererinverse.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/20
/*---------------------------------------------------------------
Update : 2017/6/20
			meshrendererinverse.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "mesh_rendererinverse.h"


#include "texture_interface.h"
#include "vertexbuffer.h"
#include "indexbuffer.h"
#include "matrix.h"

#include "rendering_order.h"
#include "rendering_order_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/




// MeshRendererInverse Constructor
MeshRendererInverse::MeshRendererInverse( VertexBuffer** ppVtxBuf, IndexBuffer** ppIdxBuf, TextureInterface** ppTexture, Matrix* pMtx )
	: RenderInterface(3)
	, ppVtxBuf( ppVtxBuf )
	, ppIdxBuf( ppIdxBuf )
	, ppTexture( ppTexture )
	, pMtx( pMtx )
{

	// Menber Clear Process

}

// MeshRendererInverse Destructor
MeshRendererInverse::~MeshRendererInverse( )
{

	// Do Nothing!!

}

// MeshRendererInverse Create Instance 
MeshRendererInverse* MeshRendererInverse::SetComponent( VertexBuffer** ppVtxBuf, IndexBuffer** ppIdxBuf, TextureInterface** ppTexture, Matrix* pMtx = nullptr )
{

	// Create Class Instance
	return new MeshRendererInverse( ppVtxBuf, ppIdxBuf, ppTexture, pMtx );

}

// MeshRendererInverse Draw
void MeshRendererInverse::Render( void )
{

	// Render Process
	RenderingOrderManager::Operate()->DrawIndexPrimitive( *ppVtxBuf, *ppIdxBuf, *ppTexture, pMtx );
	RenderingOrderManager::Operate()->DrawReverseObject( *ppVtxBuf, *ppIdxBuf, *ppTexture, pMtx );

}



