/***************************************************************/
//
//
//		DirectX	[ MeshRendererlist.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/20
/*---------------------------------------------------------------
Update : 2017/6/20
			Create Header File -> MeshRendererListlist.h.h 
 			< Add Class Function >
				MeshRendererList->Constructor
				MeshRendererList->Destructor
				MeshRendererList->Create ( static member )
				MeshRendererList->Init
				MeshRendererList->Uninit
				MeshRendererList->Update
				MeshRendererList->Draw

Update : 2017/6/20



/*-------------------------------------------------------------*/
#ifndef _MeshRendererListLIST_H_

#define _MeshRendererListLIST_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "render_Interface.h"

class VertexBuffer;
class TextureInterface;
class Matrix;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class MeshRendererList Using MeshRendererList
class MeshRendererList : public RenderInterface
{
public:
	
	MeshRendererList( 							// MeshRendererList constructor
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	~MeshRendererList( );						// MeshRendererList destructor

	static MeshRendererList* SetComponent( 		// MeshRendererList Create Instance Class
		VertexBuffer** ppVtxBuf,
		TextureInterface** ppTexture,
		Matrix* pMtx );
	
	void Render( void );					// MeshRendererList Draw
	

private:

	// Member Variable
	VertexBuffer** ppVtxBuf;
	TextureInterface** ppTexture;
	Matrix* pMtx;
	

};


#endif	//	_MeshRendererListLIST_H_


