/***************************************************************/
//
//
//		DirectX	[ modeldx9interface.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			Create Header File -> modeldx9interface.h.h 
 			< Add Class Function >
				ModelDX9Interface->Constructor
				ModelDX9Interface->Destructor
				ModelDX9Interface->Create ( static member )
				ModelDX9Interface->Init
				ModelDX9Interface->Uninit
				ModelDX9Interface->Update
				ModelDX9Interface->Draw

Update : 2017/6/9



/*-------------------------------------------------------------*/
#ifndef _MODELDX9INTERFACE_H_

#define _MODELDX9INTERFACE_H_


/*---------------------------------------------------------------
	Include
---------------------------------------------------------------*/

#include "model_interface.h"

#include "rendererdx9.h"


class TextureInterface;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class ModelDX9Interface Using ModelDX9Interface
class ModelDX9Interface : public ModelInterface
{
public:

	ModelDX9Interface( );						// ModelDX9Interface Constructor
	~ModelDX9Interface( );						// ModelDX9Interface Destructor

	static ModelDX9Interface* Create( void );	// ModelDX9Interface Create Instance Class

	void Release( void );						// ModelDX9Interface Uninitialize
	bool Load( 									// ModelDX9Interface Load
		const char* FILE_NAME );

	LPD3DXMESH GetMesh( void );					// ModelDX9Interface GetMesh
	LPD3DXBUFFER GetMatBuffer( void );			// ModelDX9Interface GetMaterialBuffer
	DWORD GetMatNumber( void );					// ModelDX9Interface GetMatNumber
	TextureInterface* GetTexture(				// ModelDX9Interface GetTexture
		const int& index );


private:

	// Member Variable
	LPD3DXMESH   pMesh;						// MeshInterfacePointer
	LPD3DXBUFFER pBufMat;					// MaterialInfo
	DWORD        matNum;					// MaterialNumber
	
	TextureInterface** ppTexture;			// TexutureInterface


};


#endif	//	_MODELDX9INTERFACE_H_


