/***************************************************************/
//
//
//		DirectX	[ procmethod.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/13
/*---------------------------------------------------------------
Update : 2017/6/13
			procmethod.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include <Windows.h>

#include "window.h"
#include "proc_method.h"

#include "resource.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

using namespace ProcMethod;

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/



// DialogInstance
void ProcMethod::DialogInstance( unsigned int id,__in_opt DLGPROC lpDialogFunc )
{

	HWND hDlgWnd = CreateDialog(
		(HINSTANCE)GetWindowLong(
		Window::GetWindowHandle(),GWL_HINSTANCE),
		MAKEINTRESOURCE(id),
		Window::GetWindowHandle(),
		lpDialogFunc);

	ShowWindow( hDlgWnd, SW_SHOW );
}

// PopUpMenuInstance
void ProcMethod::PopUpMenuInstance( unsigned int id, const POINT& point )
{

	HMENU hMenu = LoadMenu(
		(HINSTANCE)GetWindowLong( Window::GetWindowHandle(), GWL_HINSTANCE),
		MAKEINTRESOURCE( id ));
	HMENU hSubMenu = GetSubMenu( hMenu, 0 );

	TrackPopupMenu( hSubMenu, 0, point.x, point.y, 0, Window::GetWindowHandle(), NULL );

	DestroyMenu(hMenu);

}

// SaveFileDialog
void ProcMethod::SaveFileDialog( const std::string& filename, unsigned int flag )
{

}

// OpenFileDialog
void ProcMethod::OpenFileDialog( unsigned int flag )
{

	OPENFILENAME ofn;
	char szFile[260];	// for FileProcess
	char strMsg[250];	// for Message

	lstrcpy( szFile, "*.bin" );

	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = NULL;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFilter = " Format BIN \0*.bin\0Gif Format\0*.gif\0All\0*.*\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = flag;

	if( !GetOpenFileName(&ofn) ){
		MessageBox(NULL, "t@CIĂ܂","", MB_OK | MB_ICONSTOP);
	}else{
		wsprintf(strMsg, "t@CI܂B\nt@C\n%s\nłB",szFile);
		MessageBox(NULL, strMsg, "", MB_OK | MB_ICONINFORMATION);

		char filename[255] = { };		// t@Cl[
		char extension[255] ={ };		// gq

		// splitpath
		_splitpath(  &ofn.lpstrFile[0], NULL, NULL, filename, extension );
		sprintf(  &ofn.lpstrFile[0], "%s%s", filename , extension );

		// t@CI[v
	}
}

// Method CloseWinMsg
Method ProcMethod::CloseWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{

	const char WINDOW_MSG[ ] = { "I܂H" };

	// WindowI
	if( MessageBox(NULL,WINDOW_MSG,APPLICATION_NAME, MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2) == IDNO ){
		uMsg = NULL;
	}

	return 0;
}

// Method CreateWinMsg
Method ProcMethod::CreateWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	
	DragAcceptFiles(hWnd,true);
	return 0;
}

// Method DestoryWinMsg
Method ProcMethod::DestoryWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	
	PostQuitMessage(0);
	return 0;
}

// Method CommandWinMsg
Method ProcMethod::CommandWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	return 0;
}

// Method SizeWinMsg
Method ProcMethod::SizeWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	
	Window::width  = LOWORD(lParam);
	Window::height = HIWORD(lParam);

	Window::width  -= GetSystemMetrics(SM_CXDLGFRAME) * 2;
	Window::height -= GetSystemMetrics(SM_CYDLGFRAME) * 2 + GetSystemMetrics(SM_CYDLGFRAME);

	return 0;
}

// Method DropFileWinMsg
Method ProcMethod::DropFileWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{

	char buf[MAX_PATH]={};
	int fileCount = DragQueryFile( (HDROP)wParam, -1, nullptr, 0 );

	for( int index = 0; index < fileCount; index++ ){
		DragQueryFile((HDROP)wParam,index,buf,MAX_PATH );
		// t@C
		MessageBox(NULL,buf,"t@C",0);
	}

	return 0;
}

// Method KeydownWinMsg
Method ProcMethod::KeydownWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{

	const char WINDOW_MSG[ ] = { "I܂H" };

	// ESCI
	if( wParam == VK_ESCAPE ) {					
		if( MessageBox(NULL,WINDOW_MSG,APPLICATION_NAME, MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2) == IDYES ){
			DestroyWindow(hWnd);
		}
	}

	return 0;

}

// Method LBtnDownWinMsg
Method ProcMethod::LBtnDownWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	
	POINT pt;
	pt.x = LOWORD(lParam);
	pt.y = HIWORD(lParam);
	ClientToScreen( hWnd, &pt );
	
	//PopUpMenuInstance(IDR_MENU2,pt);

	//DialogInstance( IDD_DIALOG1,Window::DlgProc );

	return 0;
}

// Method RBtnDownWinMsg
Method ProcMethod::RBtnDownWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	return 0;
}

// Method LBtnReleaseWinMsg
Method ProcMethod::LBtnReleaseWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	return 0;
}

// Method RBtnReleaseWinMsg
Method ProcMethod::RBtnReleaseWinMsg( HWND& hWnd, UINT& uMsg, WPARAM& wParam, LPARAM& lParam)
{
	return 0;
}






