/***************************************************************/
//
//
//		DirectX	[ rendererdx9.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/10
/*---------------------------------------------------------------
Update : 2017/5/10
			Create Header File -> rendererdx9.h.h 
 			< Add Class Function >
				RendererDX9->Constructor
				RendererDX9->Destructor
				RendererDX9->Create ( static member )
				RendererDX9->Init
				RendererDX9->Uninit
				RendererDX9->Update
				RendererDX9->Draw

Update : 2017/5/10



/*-------------------------------------------------------------*/
#ifndef _RENDERERDX9_H_

#define _RENDERERDX9_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "renderer.h"

#include <Windows.h>
#include <d3dx9.h>

#pragma comment (lib,"d3d9.lib")
#pragma comment (lib,"d3dx9.lib")


#ifndef SAFE_DELETE
#define SAFE_DELETE(p)       { if (p) { delete (p);     (p)=NULL; } }
#endif

#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY(p) { if (p) { delete[] (p);   (p)=NULL; } }
#endif

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p)      { if (p) { (p)->Release(); (p)=NULL; } }
#endif

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class RendererDX9 Using RendererDX9
class RendererDX9 : public Renderer
{
public:
	
	RendererDX9( );							// RendererDX9 constructor
	~RendererDX9( );						// RendererDX9 destructor

	static Renderer* Create( void );		// RendererDX9 Create Instance Class

	void Init( HWND hWnd, bool bWindow );	// RendererDX9 Initialize
	void Uninit( void );					// RendererDX9 Uninitialize
	bool RenderBegin( void );				// RendererDX9 Draw Start
	void RenderEnd( void );					// RendererDX9 Draw End
	void Present( void );					// RendererDX9 Present Backbuffer
	
	LPDIRECT3DDEVICE9 GetDevice( void );	// RendererDX9 GetDeviceInfo

	virtual void RenderState(				// RendererDX9 SetRenderState
		int* stateArray,
		bool* flaglist,
		int dataNumber );
	
private:

	// Member Function
	LPDIRECT3D9				pD3D;			// Direct3DObject
	LPDIRECT3DDEVICE9		pD3DDevice ;	// DeviceObject(`ɕKv)

};

namespace RendererDevice
{
	LPDIRECT3DDEVICE9 GetDevice( void );
};

using namespace RendererDevice;



#endif	//	_RENDERERDX9_H_


