/***************************************************************/
//
//
//		DirectX	[ renderingorderdx9.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/24
/*---------------------------------------------------------------
Update : 2017/5/24
			Create Header File -> renderingorderdx9.h.h 
 			< Add Class Function >
				RENDERINGORDERDX9->Constructor
				RENDERINGORDERDX9->Destructor
				RENDERINGORDERDX9->Create ( static member )
				RENDERINGORDERDX9->Init
				RENDERINGORDERDX9->Uninit
				RENDERINGORDERDX9->Update
				RENDERINGORDERDX9->Draw

Update : 2017/5/24



/*-------------------------------------------------------------*/
#ifndef _RENDERINGORDERDX9_H_

#define _RENDERINGORDERDX9_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "rendering_order.h"


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class RenderingOrderDX9 Using RenderingOrderDX9
class RenderingOrderDX9 : public RenderingOrder
{
public:
	
	RenderingOrderDX9( );						// RenderingOrderDX9 Constructor
	~RenderingOrderDX9( );						// RenderingOrderDX9 Destructor

	static RenderingOrderDX9* Create( void );	// RenderingOrderDX9 Create Instance Class

	void DrawPrimitiveStrip(					// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	void DrawPrimitiveStripAddBlend(
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture,
		Matrix* mtx );

	void DrawPrimitiveList(						// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	void DrawPrimitiveFan(						// RenderingOrder DrawPrimitive
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );
	void DrawSubset( 							// RenderingOrder DrawSubset
		ModelInterface* pMeshObj,
		Matrix* mtx = nullptr );		
	
	void DrawIndexPrimitive( 					// RenderingOrder DrawIndexPrimitive
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	void DrawBillboard( 
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	void DrawBillboardAddBlend( 
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture,
		Matrix* mtx );


	void Draw3DUserInterface( 
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr,
		Matrix* mtx = nullptr );

	void Draw3DUserInterfaceAddBlend( 
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture,
		Matrix* mtx );


	void DrawLineList( 
		VertexBuffer* pVtxBuf,
		Matrix* mtx );

	void DrawPrimitiveCurringOff(				// RenderingOrder DrawPrimitive CurringOff
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture,
		Matrix* mtx	);

	void DrawReverseObject(						// RenderingOrder DrawPrimitive CurringOff
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture,
		Matrix* mtx	);

	// for Ortho Coord
	void DrawSprite(
		VertexBuffer* pVtxBuf,
		TextureInterface* pTexture = nullptr );

	void DrawSpriteEx(
		VertexBuffer* pVtxBuf,
		IndexBuffer* pIdxBuf,
		TextureInterface* pTexture = nullptr );

private:

	// Member Variable


};


#endif	//	_RENDERINGORDERDX9_H_


