/***************************************************************/
//
//
//		DirectX	[ renderinterfacemanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/12
/*---------------------------------------------------------------
Update : 2017/6/12
			renderinterfacemanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "renderinterface_manager.h"

#include "render_interface.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

RenderInterfaceManager* RenderInterfaceManager::pManager = nullptr;




// RenderInterfaceManager Constructor
RenderInterfaceManager::RenderInterfaceManager( )
{

	// Member Clear Process
	Release();
	pManager = this;

}

// RenderInterfaceManager Destructor
RenderInterfaceManager::~RenderInterfaceManager( )
{

	// Do Nothing!!

}

// RenderInterfaceManager Create Instance 
RenderInterfaceManager* RenderInterfaceManager::Create( void )
{

	// Create Class Instance
	return new RenderInterfaceManager;

}

// RenderInterfaceManager Registry
void RenderInterfaceManager::Registry( RenderInterface* data, const int priority )
{

	// Registry Process
	pManager->data[priority].push_back(data);

}

// RenderInterfaceManager Delete
void RenderInterfaceManager::Delete( const RenderInterface* object )
{

	for( int priority = 0; priority < PRIORITY_NUMBER; priority++ ){
		for( int index = pManager->data[priority].size(); index > 0; index-- ){
			if( pManager->data[priority][index-1] == object ){
				delete pManager->data[priority][index-1];
				pManager->data[priority].erase( pManager->data[priority].begin() + index-1 );
			}
		}
	}

}

// RenderInterfaceManager Destory
void RenderInterfaceManager::Destory( void )
{

	for( int priority = 0; priority < PRIORITY_NUMBER; priority++ ){
		for( int index = data[priority].size(); index > 0; index-- ){
			if( data[priority][index-1]){
				delete data[priority][index-1];
			}
			data[priority].pop_back();
		}
	}

}

// RenderInterfaceManager Release
void RenderInterfaceManager::Release( void )
{

	// Release Process
	if(pManager){
		pManager->Destory();
		delete pManager;
	}
}

// RenderInterfaceManager Render
void RenderInterfaceManager::Render( void )
{

	// Draw Process
	for( int priority = 0; priority < PRIORITY_NUMBER; priority++ ){
		if( priority == 6 ){
			int i = 0;
		}
		for( int index = 0; index < pManager->data[priority].size(); index++ ){
			pManager->data[priority][index]->Render();
		}
	}

}







