/***************************************************************/
//
//
//		DirectX	[ scene.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/11
/*---------------------------------------------------------------
Update : 2017/5/11
			Create Header File -> scene.h.h 
 			< Add Class Function >
				ScENE->Constructor
				ScENE->Destructor
				ScENE->Create ( static member )
				ScENE->Init
				ScENE->Uninit
				ScENE->Update
				ScENE->Draw

Update : 2017/5/11



/*-------------------------------------------------------------*/
#ifndef _SCENE_H_

#define _SCENE_H_

/*---------------------------------------------------------------
	IncludeFile + other
---------------------------------------------------------------*/

#include <vector>

class GameObject;
class GameComponent;

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class Scene Using Scene
class Scene
{
public:
	
	// Scene Kinds
	typedef enum{
	
		NULL_SCENE = 0,
		SCENE_TITLE,
		SCENE_TUTORIAL,
		SCENE_STANDBY,
		SCENE_SELECT,
		SCENE_GAME,
		SCENE_RESULT,
		SCENE_RANKING,
		SCENE_OPENING,
		SCENE_ENDING,
		SCENE_MAX,
		
	}SCENE;
	
	Scene( );							// Scene constructor
	~Scene( );							// Scene destructor

	virtual void Init( void ) = 0;		// Scene Initialize
	virtual void Uninit( void ) = 0;	// Scene Uninitialize
	virtual void Update( void ) = 0;	// Scene Update
	virtual void Draw( void ){}
	
	virtual void AbsUpdate( void ){ }	// Event Update ( for Absolute Update ) 

protected:

	// Member Function
	std::vector<GameObject*>    object;
	std::vector<GameComponent*> component;


};

// NullInterface Scene
class NullScene : public Scene
{
public:
	static Scene* Create( void ){
		return new NullScene;
	}

	void Init( void ){};			// Scene Initialize
	void Uninit( void ){};			// Scene Uninitialize
	void Update( void ){};			// Scene Update

};


#endif	//	_SCENE_H_


