/***************************************************************/
//
//
//		DirectX	[ scenemanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/15
/*---------------------------------------------------------------
Update : 2017/5/15
			scenemanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "window.h"
#include "scene_manager.h"


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

SceneManager* SceneManager::pManager = nullptr;

SelectScene SceneManager::pSceneFunc[ Scene::SCENE_MAX ] = {
	NullScene::Create,

};



// SceneManager Constructor
SceneManager::SceneManager( )
	: pScene(nullptr)
{

	// Menber Clear Process
	if( !pManager ){
		pManager = this;
	}

}

// SceneManager Destructor
SceneManager::~SceneManager( )
{

	// Do Nothing!!

}

// SceneManager Create Instance 
SceneManager* SceneManager::Create( void )
{

	// Create Class Instance
	SceneManager* pObject;
	pObject = new SceneManager;

	return pObject;

}

// SceneManager Initialize
void SceneManager::Init( const Scene::SCENE& scene )
{

	// Scene Change
	pScene = pSceneFunc[ scene ]( );
	
	// Initialize Scene
	pScene->Init( );

}

// SceneManager Initialize
void SceneManager::Init( Scene* pScene )
{

	// Initialize Process
	SceneManager::pScene = pScene;
	
	SceneManager::pScene->Init( );

}

// SceneManager Uninitialize
void SceneManager::Uninit( void )
{

	// Uninitialize Process
	pScene->Uninit( );
	SAFE_DELETE( pScene )
	
	SAFE_DELETE( pManager )
	return;
	
}

// SceneManager GetSceneInstanceAddress
Scene* SceneManager::GetScene( void )
{

	// Get Scene Process
	return pScene;

}

// Scene Change
void SceneManager::ChangeScene( const Scene::SCENE& nextScene )
{
	
	// Release Scene
	pManager->pScene->Uninit( );
	SAFE_DELETE( pManager->pScene )
	
	// Scene Change
	pManager->pScene = pSceneFunc[ nextScene ]( );
	
	// Initialize Scene
	pManager->pScene->Init( );
	
}

// Scene Change
void SceneManager::ChangeScene( Scene* pScene )
{

	// Release Scene
	pManager->pScene->Uninit( );
	SAFE_DELETE( pManager->pScene )

	// Scene Change
	pManager->pScene = pScene;
	
	// Initialize Scene
	pManager->pScene->Init( );

}





