/***************************************************************/
//
//
//		DirectX	[ scoreframe.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 9/10
/*---------------------------------------------------------------
Update : 2016/9/10
			scoreframe.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "score_frame.h"

#include "rendererdx9.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NAME "data/TEXTURE/score_frame000.png"		// eNX`pX

#define NUM_VERTEX  ( 4 )									// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )									// `悷|S

#define START_COORD_X (900)									// \WSX
#define START_COORD_Y (-20)									// \ʒuSY
#define END_COORD_X   (1350)								// \WEX
#define END_COORD_Y   (120)									// \WEX

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexScoreFrame( LPDIRECT3DDEVICE9 pDevice );	// _̍쐬
void SetVertexScoreFrameCoord( VERTEX_2D* pVtx );			// _W̐ݒ
void SetVertexScoreFrameSpriteUV( VERTEX_2D* pVtx );		// _UVl̐ݒ
void SetVertexScoreFrameColor( VERTEX_2D* pVtx );			// _F̐ݒ

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureScoreFrame = nullptr;			// eNX`-C^[tF-X
LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferScoreFrame = nullptr;	// _obt@C^[tF[Xւ̃|C^


// SCOREFRAMȄ
void InitScoreFrame( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexScoreFrame( pDevice );

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME, &g_pTextureScoreFrame )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "SCOREFRAMEeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}


}

// SCOREFRAMȄI
void UninitScoreFrame( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE( g_pTextureScoreFrame )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( g_pVtxBufferScoreFrame )

}

// SCOREFRAME̍XV
void UpdateScoreFrame( void )
{

	VERTEX_2D *pVtx;										// zAhX


	// obt@bNzAhX擾
	g_pVtxBufferScoreFrame -> Lock( 0, 0, (void**)&pVtx, 0 );

	///*
	{// _obt@̐ݒ


		// _W̐ݒ
		//SetVertexScoreFrameCoord( pVtx );

		// _UVl̐ݒ
		//SetVertexScoreFrameSpriteUV( pVtx );

		// _F̐ݒ
		SetVertexScoreFrameColor( pVtx );

		// rhw̐ݒ
		//pVtx[0].rhw = 1.0f;
		//pVtx[1].rhw = 1.0f;
		//pVtx[2].rhw = 1.0f;
		//pVtx[3].rhw = 1.0f;


	}// SetVertex -> END 
	//*/

	g_pVtxBufferScoreFrame ->Unlock( );


}

// SCOREFRAME̕`
void DrawScoreFrame( void )
{


	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferScoreFrame,							// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_2D ));							// ̃XgChl(oCgP)


	// _tH[}bg̐ݒ
	pDevice ->SetFVF( FVF_VERTEX_2D );


	// eNX`̐ݒ
	pDevice ->SetTexture( 0, g_pTextureScoreFrame );

	// Z̐ݒ
	pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );			//
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );			//̃

	// |S̕`
	pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON );

	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );		//̃
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );		//̃]


}

// _̍쐬
HRESULT MakeVertexScoreFrame( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;									// zAhX


	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_2D ) * NUM_VERTEX,			// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&g_pVtxBufferScoreFrame,						// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " SCOREFRAME VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return E_FAIL;
	}


	// zAhX̎擾
	g_pVtxBufferScoreFrame -> Lock( 0, 0, (void**)&pVtx, 0 );


	{ // _obt@̐ݒ

		// _W̐ݒ
		SetVertexScoreFrameCoord( pVtx );

		// _UVl̐ݒ
		SetVertexScoreFrameSpriteUV( pVtx );

		// _F̐ݒ
		SetVertexScoreFrameColor( pVtx );

		// rhw̐ݒ
		pVtx[0].rhw = 1.0f;
		pVtx[1].rhw = 1.0f;
		pVtx[2].rhw = 1.0f;
		pVtx[3].rhw = 1.0f;

	} // SetVertex -> END 


	// obt@̃AbN
	g_pVtxBufferScoreFrame ->Unlock( );

	return S_OK;


}

// _W̐ݒ
void SetVertexScoreFrameCoord( VERTEX_2D* pVtx )
{


	D3DXVECTOR2 start,end;				// n_ƏI_
	D3DXVECTOR2 center;					// SW
	D3DXVECTOR2 radius;					// XvCga
	D3DXVECTOR2 coord[ NUM_VERTEX ];	// W̌vZli[p
	static float arc;					// ]px
	static float scale = 1.0f;			// gkl



	{ // Wl

		// a̐ݒ
		radius.x = (( END_COORD_X - START_COORD_X ) * 0.5f ); 
		radius.y = (( END_COORD_Y - START_COORD_Y ) * 0.5f ); 

		// SW̐ݒ
		center.x = START_COORD_X + radius.x;
		center.y = START_COORD_Y + radius.y;

	} // -> ݒI



	// XvCggk
	scale += 0.0f;

	{ // XP[

		radius *= scale;

	}

	// XvCg]
	arc -= 360;

	{ // AtBϊ


		coord[ 0 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, -radius.y, arc );
		coord[ 0 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, -radius.y, arc );

		coord[ 1 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, -radius.y, arc );
		coord[ 1 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, -radius.y, arc );

		coord[ 2 ].x = center.x + AFFINE_TRANSFORM_X( -radius.x, radius.y, arc );
		coord[ 2 ].y = center.y + AFFINE_TRANSFORM_Y( -radius.x, radius.y, arc );

		coord[ 3 ].x = center.x + AFFINE_TRANSFORM_X( radius.x, radius.y, arc );
		coord[ 3 ].y = center.y + AFFINE_TRANSFORM_Y( radius.x, radius.y, arc );


	} // -> ϊI


	// W̏
	for( int index = 0; index < NUM_VERTEX; index++ )
	{
		pVtx[ index ].pos=D3DXVECTOR3( coord[ index ].x, coord[ index ].y  , 0.0f );
	}


	/*
	// W̐ݒ
	start.x = START_COORD_X;
	start.y = START_COORD_Y;
	end.x   = END_COORD_X;
	end.y   = END_COORD_Y;


	// W̏
	pVtx[0].pos=D3DXVECTOR3( start.x, start.y, 0.0f );
	pVtx[1].pos=D3DXVECTOR3( end.x  , start.y, 0.0f );
	pVtx[2].pos=D3DXVECTOR3( start.x, end.y  , 0.0f );
	pVtx[3].pos=D3DXVECTOR3( end.x  , end.y  , 0.0f );
	*/



}

// _UVl̐ݒ
void SetVertexScoreFrameSpriteUV( VERTEX_2D* pVtx )
{


	const unsigned int TEXTURE_SHEETS_U = 1;		// eNX`Aj[V
	const unsigned int TEXTURE_SHEETS_V = 1;		// eNX`cAj[V
	const unsigned int FPS = 1 ;					// t[p[ZJh(҂)
	const float TEXTURE_U = 1.0f / TEXTURE_SHEETS_U;// eNX` U l萔
	const float TEXTURE_V = 1.0f / TEXTURE_SHEETS_V;// eNX` V l萔
	float TexU = 0,TexV = 0;						// eNX`UVľvZɎgp
	static unsigned int animationFrame;				// Aj[Vt[



	// UVľvZ
	TexU = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_U ) * TEXTURE_U;
	TexV = ( float )( ( animationFrame / FPS ) % TEXTURE_SHEETS_V ) * TEXTURE_V;


	// _UVl̏
	pVtx[0].tex = D3DXVECTOR2( TexU            , TexV );
	pVtx[1].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV );
	pVtx[2].tex = D3DXVECTOR2( TexU            , TexV + TEXTURE_V );
	pVtx[3].tex = D3DXVECTOR2( TexU + TEXTURE_U, TexV + TEXTURE_V );


	// Aj[Vt[̍XV
	animationFrame ++;


}

// _F̐ݒ
void SetVertexScoreFrameColor( VERTEX_2D* pVtx )
{

	static D3DXCOLOR vertexColor = D3DXCOLOR( 0.3f, 0.3f, 1.0f, 1.0f );	// _F

	const float MAX_COLOR = 1.0f;										// F̍ől
	const float MIM_COLOR = 0.3f;										// F̍ŏl
	const float TRANSLATE_COLOR = 0.005f;								// t[̐F̍XVl
	static float transitionColor = 0.0f;								// FύXl
	static bool frag = true;											// ܂ԂtO


	// F̑J
	if( transitionColor >= MAX_COLOR ){

		frag = false;
	}

	if( frag ){

		transitionColor += TRANSLATE_COLOR;
	}
	else{

		transitionColor -= TRANSLATE_COLOR;

		if( transitionColor <= MIM_COLOR ){

			frag = true;
		}
	}



	{ // _F̍XV

		//vertexColor.r = transitionColor; 
		//vertexColor.g = transitionColor; 
		vertexColor.b = transitionColor; 
		//vertexColor.a = transitionColor; 
	}



	// _F̏
	pVtx[0].color = D3DXCOLOR( vertexColor.r, vertexColor.g, vertexColor.b, vertexColor.a );
	pVtx[1].color = D3DXCOLOR( vertexColor.r-0.25f, vertexColor.g-0.25f, vertexColor.b-0.25f, vertexColor.a );
	pVtx[2].color = D3DXCOLOR( vertexColor.r-0.25f, vertexColor.g-0.25f, vertexColor.b-0.25f, vertexColor.a );
	pVtx[3].color = D3DXCOLOR( vertexColor.r-5.0f, vertexColor.g-5.0f, vertexColor.b-5.0f, vertexColor.a );



}




