/***************************************************************/
//
//
//		DirectX	[ shell.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/8
/*---------------------------------------------------------------
Update : 2017/6/8
			Create Header File -> shell.h.h 
 			< Add Class Function >
				SHELL->Constructor
				SHELL->Destructor
				SHELL->Create ( static member )
				SHELL->Init
				SHELL->Uninit
				SHELL->Update
				SHELL->Draw

Update : 2017/6/8



/*-------------------------------------------------------------*/
#ifndef _SHELL_H_

#define _SHELL_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "base.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Shell Using Shell
class Shell : public Base
{
public:
	
	typedef enum{
	
		DIR_UP = 0,
		DIR_RIGHT,
		DIR_DOWN,
		DIR_LEFT,
		DIR_MAX,
	}Direction;
	
	Shell( );						// Shell Constructor
	~Shell( );						// Shell Destructor

	static Shell* Create( void );	// Shell Create Instance Class

	void Init( void );				// Shell Initialize
	void Uninit( void );			// Shell Uninitialize
	void Update( void );			// Shell Update
	void Draw( void );				// Shell Draw
	
	void OnContact( void );			// Shell Contact Process

	virtual void OnScissor( void );	// ͂܂ꂽƂ
	virtual void Scissor( void );	// ͂񂾂Ƃ

	void SetDirection( 				// Shell Set <Direction>
		int dir );

	bool GetFlag( void ){
		return awakeflag;
	}

	void SetMoveflag( bool flag ){
		moveflag = flag;
	}

	int dir;

protected:

	// Member Variable
	Vector3 lookat;
	bool awakeflag;
	bool moveflag;

};


#endif	//	_SHELL_H_


