/***************************************************************/
//
//
//		DirectX	[ sprite.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/15
/*---------------------------------------------------------------
Update : 2017/6/15
			sprite.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "sprite.h"

#include "texture_interface.h"
#include "texture_manager.h"
#include "vertexbuffer.h"
#include "vertexbuffer_manager.h"

#include "mesh_renderersprite.h"

#include "vertex2d.h"
#include "window.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// Sprite Constructor
Sprite::Sprite( const char* filename )
	: pObject(nullptr)
	, pTexture(nullptr)
	, pVtxBuf(nullptr)
{

	// Member Clear Process
	pTexture = TextureManager::LoadFromManager( filename );

}

// Sprite Destructor
Sprite::~Sprite( )
{

	// Do Nothing!!

}

// Sprite Create Instance 
Sprite* Sprite::Create( const char* filename )
{

	// Create Class Instance
	return new Sprite(filename);

}

// Sprite Initialize
void Sprite::Init( void )
{

	// Initialize Process
	pVtxBuf = VertexBufferManager::PlatformSelect();
	MakeVertex( 4 );

	pObject = MeshRendererSprite::SetComponent( &pVtxBuf, &pTexture );

}

// Sprite Uninitialize
void Sprite::Uninit( void )
{

	// Uninitialize Process
	pVtxBuf->Release( );
	SpriteInterfaceManager::Delete( pObject );
	
}

// Sprite Update
void Sprite::Update( void )
{

	// Update Process


}

// Sprite MakeVertex
void Sprite::MakeVertex( const int vertexNumber )
{

	pVtxBuf->CreateVertexBuffer( FVF_VERTEX_2D, vertexNumber, sizeof(Vertex2D) );

	SetVertex( );


}

// Sprite MakeVertex
void Sprite::SetVertex( const Color& color, const Vector3& start, const Vector3& end )
{

	Vertex2D* pVtx;

	pVtxBuf->Lock( &pVtx );

	pVtx[0].pos = Vector3(start.x,start.y,0);
	pVtx[0].tex = Vector2(0,0);
	pVtx[0].color = color;
	pVtx[0].rhw = 1.0f;

	pVtx[1].pos = Vector3(end.x,start.y,0);
	pVtx[1].tex = Vector2(1,0);
	pVtx[1].color = color;
	pVtx[1].rhw = 1.0f;

	pVtx[2].pos = Vector3(start.x,end.y,0);
	pVtx[2].tex = Vector2(0,1);
	pVtx[2].color = color;
	pVtx[2].rhw = 1.0f;

	pVtx[3].pos = Vector3(end.x,end.y,0);
	pVtx[3].tex = Vector2(1,1);
	pVtx[3].color = color;
	pVtx[3].rhw = 1.0f;

	pVtxBuf->Unlock( );


}

// Sprite Lock
void Sprite::Lock( Vertex2D* pVtx )
{

	pVtxBuf->Lock( &pVtx );

}

// Sprite Unlock
void Sprite::Unlock( void )
{

	pVtxBuf->Unlock( );

}





