/***************************************************************/
//
//
//		DirectX	[ sprite.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/15
/*---------------------------------------------------------------
Update : 2017/6/15
			Create Header File -> sprite.h.h 
 			< Add Class Function >
				Sprite->Constructor
				Sprite->Destructor
				Sprite->Create ( static member )
				Sprite->Init
				Sprite->Uninit
				Sprite->Update
				Sprite->Draw

Update : 2017/6/15



/*-------------------------------------------------------------*/
#ifndef _SPRITE_H_

#define _SPRITE_H_



/*---------------------------------------------------------------
	Include File 
---------------------------------------------------------------*/

#include "gameobject.h"

#include "vector3.h"
#include "vector2.h"
#include "color.h"

#include "window.h"

class SpriteInterface;
class TextureInterface;
class VertexBuffer;

class Vertex2D;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Sprite Using Sprite
class Sprite
{
public:
	
	Sprite( const char* filename );	// Sprite Constructor
	~Sprite( );						// Sprite Destructor

	static Sprite* Create(			// Sprite Create Instance Class
		const char* filename );	

	void Init( void );				// Sprite Initialize
	void Uninit( void );			// Sprite Uninitialize
	void Update( void );			// Sprite Update

	virtual void MakeVertex(		// Sprite MakeVertex
		const int vertexNumber );

	virtual void SetVertex(			// Sprite MakeVertex 
		 const Color& color = Color(1,1,1,1),
		 const Vector3& start = Vector3( 0,0,0 ),
		 const Vector3& end = Vector3((float)Window::SCREEN_WIDTH,(float)Window::SCREEN_HEIGHT,0)  );

	void Lock( Vertex2D* pVtx );	// Sprite Lock
	void Unlock( void );			// Sprite Unlock

private:

	// Member Variable
	Vector2 pos;
	Vector2 rot;

	SpriteInterface*  pObject;
	TextureInterface* pTexture;
	VertexBuffer*     pVtxBuf;
	

};


#endif	//	_SPRITE_H_


