/***************************************************************/
//
//
//		DirectX	[ systempipeline.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/9
/*---------------------------------------------------------------
Update : 2017/6/9
			systempipeline.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "system_pipeline.h"

#include "camera.h"

#include "event.h"

// for Rendering Call
#include "rendering_order_manager.h"

// for Scene Render
#include "renderinterface_manager.h"	// 3D 
#include "sprite_interfacemanager.h"	// 2D (ortho Coord)

// for Scene Management
#include "scene_manager.h"

#include "screen_transition.h"

// for Object Management
#include "gameobject_manager.h"

// for Resource manager
#include "texture_manager.h"
#include "model_manager.h"
#include "videorenderer.h"

#include "main_scene.h"

#include "swap_effect.h"
#include "fade.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

SystemPipeline* SystemPipeline::system = nullptr;




// SystemPipeline Constructor
SystemPipeline::SystemPipeline( )
	: pSceneManager(nullptr)
	, transition(nullptr)
	, cameraNumber(0)
{

	// Member Clear Process
	if( system ){
		delete system;
	}
	system = this;

}

// SystemPipeline Destructors
SystemPipeline::~SystemPipeline( )
{

	// Do Nothing!!

}

// SystemPipeline Create Instance 
SystemPipeline* SystemPipeline::Create( void )
{

	// Create Class Instance
	return new SystemPipeline;

}

// SystemPipeline Initialize
void SystemPipeline::Init( void )
{

	// Initialize Process
	RenderingOrderManager::Setup();

	// Create < GameObjectManager >
	GameObjectManager::Create();

	RenderInterfaceManager::Create();
	SpriteInterfaceManager::Create();

	transition = ScreenTransition::Create();

	pSceneManager = SceneManager::Create( );

	pSceneManager ->Init( new GameScene::Main );
	SwapEffect::Instance<Fade>()->Init();

	SystemPipeline::SetCamera( 0 );


}

// SystemPipeline Uninitialize
void SystemPipeline::Uninit( void )
{

	// Uninitialize Process
	pSceneManager ->Uninit( );

	transition->Release();

	// Uninitialize Process
	CVideoRenderer::ReleaseAll();
	TextureManager::UnloadAll();
	ModelManager::UnloadAll();

	GameObjectManager::ReleaseAll();
	
	RenderInterfaceManager::Release();
	SpriteInterfaceManager::Release();

}

// SystemPipeline Update
void SystemPipeline::Update( void )
{

	// Update Process
	if( CEvent::EventsState( ) ){

		CEvent::CallbackUpdate( );

		pSceneManager->GetScene( )->AbsUpdate();
	
	}else{

		pSceneManager->GetScene( )->Update( );

		transition->Update();
	}

}

// SystemPipeline Draw
void SystemPipeline::Render( void )
{

	// Draw Process
	for( int index = 0; index < cameraNumber; index++ ){

		Camera::Access(index)->Update();
		Camera::Access(index)->Set();
		RenderInterfaceManager::Render();
	}
	#ifdef _DEBUG
	if( !cameraNumber )
		Console::DebugLog("Camera Dont set!! : Cant 3D Graphic Rendering!! \n");
	#endif // _DEBUG

	pSceneManager->GetScene( )->Draw();
	SpriteInterfaceManager::Render();

}

// SystemPipeline SetCamera
void SystemPipeline::SetCamera(	const int number )
{

	// SetCamera
	system->cameraNumber = number;

}





