/***************************************************************/
//
//
//		DirectX	[ texturedx9interface.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/17
/*---------------------------------------------------------------
Update : 2017/5/17
			Create Header File -> texturedx9interface.h.h 
 			< Add Class Function >
				CTEXTUREDX9INTERFACE->Constructor
				CTEXTUREDX9INTERFACE->Destructor
				CTEXTUREDX9INTERFACE->Create ( static member )
				CTEXTUREDX9INTERFACE->Init
				CTEXTUREDX9INTERFACE->Uninit
				CTEXTUREDX9INTERFACE->Update
				CTEXTUREDX9INTERFACE->Draw

Update : 2017/5/17



/*-------------------------------------------------------------*/
#ifndef _TEXTUREDX9INTERFACE_H_

#define _TEXTUREDX9INTERFACE_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "texture_interface.h"

#include "rendererdx9.h"


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class TextureDX9Interface Using TextureDX9Interface
struct TextureDX9Interface : public TextureInterface
{
public:

	// Member Variable
	LPDIRECT3DTEXTURE9 data;						// Texture Address
	
public:
	
	TextureDX9Interface( );							// TextureDX9Interface constructor
	~TextureDX9Interface( );						// TextureDX9Interface destructor

	static TextureDX9Interface* Create( void );		// TextureDX9Interface Create Instance Class
	void Release( void );							// TextureDX9Interface Release
	void SetTexture( void );						// TextureDX9Interface SetTexture
	bool Load( const char* FILE_NAME );				// TextureDX9Interface Load

	TextureInterface* LoadFromManager( 
		const char* FILE_NAME );					// TextureDX9Interface Load From Manager

	
};


#endif	//	_TEXTUREDX9INTERFACE_H_


