// Scene Script
#ifndef _GAME_SCENE_TITLE_H_
#define _GAME_SCENE_TITLE_H_


#include "system_component.h"
#include "scene.h"

#include "game_background.h"

// namespace package GameScene
namespace GameScene{
	
	
	// Class Main Using SampleScene
	class Title : public Scene
	{
	private:

		// Member Variable
		UserInterface* title;
		UserInterface* logo;

		
	public:

		Title():title(nullptr),logo(nullptr){}
		
		// Initialize Method
		void Init( void ) override{

			Camera::PlatformInstance("mainCamera");
			Camera::Access()->Init();
			CLight::Create("Directional");
			
			logo = UserInterface::Create("data\\TEXTURE\\icon.png",0.480000, 0.320000, Color(1,1,1,1), Vector3(0.565000,0.250000,5.000000));
			logo->Init();

			title = UserInterface::Create("data\\TEXTURE\\title.png", 1.169999, 0.270000, Color(1,1,1,1), Vector3(-0.014999,0.260000,5.000000));
			title->Init();

			InitGameBackground();

		}
		
		// Uninitialize Method
		void Uninit( void ) override{
		
			logo->ExportOffset();
			title->Uninit();
			logo->Uninit();

			UninitGameBackground();

			CLight::ReleaseAll( );
			Camera::ReleaseAll( );
		}
		
		// Update Method
		void Update( void ) override{

			title->Update();
			logo->ReOffset();
			logo->Update();
		
			UpdateGameBackground();

			if( CXboxController::Access("playerController")->GetKeyTrigger( CXboxController::XINPUT_START )){
				ScreenTransition::Transition( ScreenTransition::DO_TRANSITION, new GameScene::Game(SET_GAME) );
			}

		}

		void Draw( void ) override{
		
			DrawGameBackground();
		}

	};
	
};



#endif	//	_GAME_SCENE_TITLE_H_


