/***************************************************************/
//
//
//		DirectX	[ userinterface.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/21
/*---------------------------------------------------------------
Update : 2017/6/21
			userinterface.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "userinterface.h"

#include "mesh_renderer3duserinterface.h"
#include "mesh_rendereruserinterfaceaddblend.h"
#include "vertexbuffer_manager.h"
#include "vertexbuffer.h"

#include "system_component.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// UserInterface Constructor
UserInterface::UserInterface( const std::string& filename,
	const float& vertical, const float& horizonal, const Color& color,
	const Vector3& pos, const Vector3& rot, const Vector3& scale, const Matrix& mat )
	: MeshPlane(filename,vertical,horizonal,color,pos,rot,scale,mat)
{
	
	// Menber Clear Process

}

// UserInterface Destructor
UserInterface::~UserInterface( )
{

	// Do Nothing!!

}

// UserInterface Create Instance 
UserInterface* UserInterface::Create( const std::string& filename,
	const float& vertical, const float& horizonal, const Color& color,
	const Vector3& pos, const Vector3& rot, const Vector3& scale, const Matrix& mat )
{

	// Create Class Instance
	return new UserInterface(filename,
		vertical,
		horizonal,
		color,
		pos,
		rot,
		scale,
		mat );

}

// UserInterface Initialize
void UserInterface::Init( void )
{

	// Initialize Process
	world = world.Identity();

	pVtxBuf = VertexBufferManager::PlatformSelect();
	if( !pVtxBuf->CreateVertexBuffer( FVF_VERTEX_3D, 4 ) ) return;

	// Set Buffer < Vertex & Index >
	SetBuffer( );

	// Component Set
	//pObject = MeshRenderer3DUserInterface::SetComponent( &pVtxBuf, &pTexture, &world );
	pObject = MeshRendererUserInterfaceAddBlend::SetComponent( &pVtxBuf, &pTexture, &world );

}

// UserInterface Uninitialize
void UserInterface::Uninit( void )
{

	// Uninitialize Process
	MeshPlane::Uninit();

}

// UserInterface Update
void UserInterface::Update( void )
{

	// Update Process
	MeshPlane::Update();

}

// UserInterface SetBuffer
void UserInterface::SetBuffer( void )
{

	// Vertual Pointer
	Vertex3D*       pVtx;

	{ // _obt@̐ݒ

		pVtxBuf->Lock( &pVtx );

		// ZClip Far to View Pos
		float zfar = 1.0f + pos.z;

		Vector3 radius( vertical*0.5f*zfar, horizonal*0.5f*zfar, 0.0f );

		//Vector3 radius( vertical*0.5f, horizonal*0.5f, 0.0f );

		// Set Vertex Coord
		pVtx[0].pos = Vector3( -radius.x + pos.x * zfar,  radius.y + pos.y * zfar, zfar );
		pVtx[1].pos = Vector3(  radius.x + pos.x * zfar,  radius.y + pos.y * zfar, zfar );
		pVtx[2].pos = Vector3( -radius.x + pos.x * zfar, -radius.y + pos.y * zfar, zfar );
		pVtx[3].pos = Vector3(  radius.x + pos.x * zfar, -radius.y + pos.y * zfar, zfar );
		//pos = Vector3(0,0,0);

		pVtx[0].tex   = Vector2( 0.0f, 0.0f );			  
		pVtx[0].color = color;		
		pVtx[0].nor   = Vector3(0, 1, 0);

		pVtx[1].tex   = Vector2( 1.0f, 0.0f );			  
		pVtx[1].color = color;			
		pVtx[1].nor   = Vector3(0, 1, 0);

		pVtx[2].tex   = Vector2( 0.0f, 1.0f );			  
		pVtx[2].color = color;			
		pVtx[2].nor   = Vector3(0, 1, 0);

		pVtx[3].tex   = Vector2( 1.0f, 1.0f );			  
		pVtx[3].color = color;			
		pVtx[3].nor   = Vector3(0, 1, 0);

		pVtxBuf->Unlock( );

	} // -> END

}

// UserInterface Resize
void UserInterface::Resize( const float width, const float height )
{

	UserInterface::vertical  = width;
	UserInterface::horizonal = height;

	// MeshPlane SetBuffer
	SetBuffer( );

}

// UserInterface ReOffset
void UserInterface::ReOffset( const Vector3& pos )
{

	UserInterface::pos = pos;

	SetBuffer( );

}

// UserInterface ReOffset
void UserInterface::ReOffset( void )
{

	if( CInputKeyboard::Access()->GetKeyTrigger(DIK_UP) ){
	
		horizonal += 0.01f;
	}
	if( CInputKeyboard::Access()->GetKeyTrigger(DIK_DOWN) ){
	
		horizonal -= 0.01f;
	}
	if( CInputKeyboard::Access()->GetKeyTrigger(DIK_LEFT) ){
	
		vertical -= 0.01f;
	}
	if( CInputKeyboard::Access()->GetKeyTrigger(DIK_RIGHT) ){
	
		vertical += 0.01f;
	}

	if( CInputKeyboard::Access()->GetKeyPress(DIK_W) ){
	
		pos.y += 0.005f;
	}
	if( CInputKeyboard::Access()->GetKeyPress(DIK_S) ){
	
		pos.y -= 0.005f;
	}
	if( CInputKeyboard::Access()->GetKeyPress(DIK_A) ){
	
		pos.x -= 0.005f;
	}
	if( CInputKeyboard::Access()->GetKeyPress(DIK_D) ){
	
		pos.x += 0.005f;
	}
	SetBuffer( );

	CDebugFont::Access()->SetRenderData( L_RENDER,"UI Adjust : x:%f y:%f z:%f \n[%p] : width %f height %f \n", pos.x, pos.y, pos.z, this, vertical, horizonal );

}

// UserInterface ExportOffset
void UserInterface::ExportOffset( void )
{

	ApplicationLog* log = ApplicationLog::BeginLog("data\\ui_adjust.txt");
	log->WriteLog("%f, %f, Color(1,1,1,1), Vector3(%f,%f,%f));",vertical,horizonal,pos.x,pos.y,pos.z);
	log->EndLog();
	delete log;

}

// UserInterface SetColor
void UserInterface::SetColor( const Color& color )
{

	UserInterface::color = color;

	SetBuffer( );

}

// UserInterface ChangeTexture
void UserInterface::ChangeTexture( const std::string& filename )
{
	
	pTexture = TextureManager::LoadFromManager(filename.data());
	
}

// UserInterface ChangeTexture
void UserInterface::SetUV( const Vector2& split, int number )
{

	// Vertual Pointer
	Vertex3D*       pVtx;

	float u = 1.0f/split.x,v = 1.0f/split.y;

	{ // _obt@̐ݒ

		pVtxBuf->Lock( &pVtx );

		float setU,setV;
	
		setU = (float)( ( number ) % (int)split.x ) * u;
		setV = (float)( (number/(int)split.x) % (int)split.y ) * v;
	
		// UVlXV
		pVtx[ 0 ].tex = Vector2( setU,   setV   );
		pVtx[ 1 ].tex = Vector2( setU+u, setV   );
		pVtx[ 2 ].tex = Vector2( setU,   setV+v );
		pVtx[ 3 ].tex = Vector2( setU+u, setV+v );
	
		// obt@̃AbN
		pVtxBuf ->Unlock();
	}
}

