/***************************************************************/
//
//
//		Aus System	[ vector3.h ]
//
//											Author	kazuki tanaka
//											Date	2017 4/24
/*---------------------------------------------------------------
Update : 2017/4/24
			Create Header File -> vector3.h.h 
 			< Add Class Function >
				CVECTOR3->Constructor
				CVECTOR3->Destructor
				CVECTOR3->Create ( static member )
				CVECTOR3->Init
				CVECTOR3->Uninit
				CVECTOR3->Update
				CVECTOR3->Draw

Update : 2017/4/24



/*-------------------------------------------------------------*/
#ifndef _VECTOR3_H_

#define _VECTOR3_H_


#include "rendererdx9.h"

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CVector3 Using Vector3
typedef struct Vector3
{
	
public:

	// Member Function
	float x;
	float y;
	float z;
	
public:
	
	Vector3( );										// Vector3 constructor
	~Vector3( );									// Vector3 destructor

	// Member Method
	float Length( void ) const;						// Vector3 Length
	float Distance( const Vector3& other ) const;	// Vector3 Distance
	Vector3 Normalize( void ) const;				// Vector3 Normalize
	Vector3 Cross( const Vector3& other ) const;	// Vector3 Cross
	float Dot( const Vector3& other ) const;		// Vector3 Dot
	float Angle( Vector3& other );					// Vector3 Angle
	
	
    Vector3( const float * );
    Vector3( const Vector3& );
	Vector3( const D3DXVECTOR3& );
	Vector3( const D3DXVECTOR3* );
    Vector3( float x, float y, float z );

    // casting
    operator float* ();
    operator const float* () const;

    // assignment operators
    Vector3& operator += ( const Vector3& other )
	{
	 	x += other.x;
		y += other.y;
		z += other.z;
		return *this;
	}
	
    Vector3& operator -= ( const Vector3& other )
	{
	 	x -= other.x;
		y -= other.y;
		z -= other.z;
		return *this;
	}
	
    Vector3& operator *= ( const float ref )
	{
	 	x *= ref;
		y *= ref;
		z *= ref;
		return *this;
	}
	
    Vector3& operator /= ( const float ref )
	{
	 	x /= ref;
		y /= ref;
		z /= ref;
		return *this;
	}

    // unary operators
    Vector3 operator + () const
	{
		return Vector3( x, y, z );
	}
	
    Vector3 operator - () const
	{
		return Vector3( -x, -y, -z );
	}
	
    // binary operators	
	Vector3 operator +( const Vector3& other ) const
	{
		return Vector3( x + other.x, y + other.y, z + other.z );
	}
	
	Vector3 operator -( const Vector3& other ) const
	{
		return Vector3( x - other.x, y - other.y, z - other.z );
	}
	
	Vector3 operator *( const float& ref ) const
	{
		return Vector3( x * ref, y * ref, z * ref );
	}
	
	Vector3 operator /( const float& ref ) const
	{
		return Vector3( x / ref, y / ref, z / ref );
	}

    //friend D3DXVECTOR3 operator * ( float, const struct Vector3& );

    bool operator == ( const Vector3& other ) const
	{
		if( x == other.x && y == other.y && z == other.z )
			return true;
		else
			return false;
	}
	
    bool operator != ( const Vector3& other ) const
	{
		if( x != other.x || y != other.y || z != other.z )
			return true;
		else
			return false;
	}

	bool operator < ( const Vector3& other ) const
	{
		if( Length() < other.Length( ) )
			return true;
		return false;
	}
	
	bool operator > ( const Vector3& other ) const
	{
		if( Length() > other.Length( ) )
			return true;
		return false;
	}

	bool operator <= ( const Vector3& other ) const
	{
		if( Length() <= other.Length( ) )
			return true;
		return false;
	}
	
	bool operator >= ( const Vector3& other ) const
	{
		if( Length() >= other.Length( ) )
			return true;
		return false;
	}


}Vector3;


#endif	//	_VECTOR3_H_


