/***************************************************************/
//
//
//		DirectX	[ virtual.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/25
/*---------------------------------------------------------------
Update : 2017/5/25
			virtual.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "virtual.h"

#include "meshfield.h"


#include "light.h"
#include "photo.h"

#include "fieldmap.h"

#include "immortal.h"
#include "shell.h"
#include "start.h"


#include "particle.h"
#include "explosion.h"

#include "camera.h"

#include "game_equation.h"





/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <cstdlib>
#include <crtdbg.h>
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)

/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// CVirtual Constructor
CVirtual::CVirtual( )
	: meshField(nullptr)
	, map(nullptr)
	, obj(nullptr)
{



}

// CVirtual Destructor
CVirtual::~CVirtual( )
{

	// Do Nothing!!

}

// CVirtual Create Instance 
CVirtual* CVirtual::Create( void )
{

	// Create Class Instance
	CVirtual* pObject;
	pObject = new CVirtual;

	return pObject;

}

// CVirtual Initialize
void CVirtual::Init( void )
{

	// Member Clear Process
	map = FieldMap::Create( );
	map->Init( "stage3_clear_debug.txt" );

	// Initialize Process
	meshField = MeshField::Create( );
	meshField->Init( );

	CPhoto::Create("effect")->Init();
	Camera::PlatformInstance("mainCamera");
	Camera::Access()->Init();

	CLight::Create( "Directional" );

	InitParticle();
	InitExplosion();


}

// CVirtual Uninitialize
void CVirtual::Uninit( void )
{

	// Uninitialize Process
	meshField->Uninit();
	delete meshField;

	map->Uninit();

	UninitParticle();
	UninitExplosion();

	CLight::ReleaseAll( );
	Camera::ReleaseAll( );
	CPhoto::ReleaseAll();


}

// CVirtual Update
void CVirtual::Update( void )
{

	// Update Process
	meshField->Update( );

	map->Update();

	UpdateParticle();
	UpdateExplosion();


	CPhoto::Access()->SetPhoto();

}

// CVirtual Draw
void CVirtual::Draw( void )
{

	DrawParticle();

}





