/***************************************************************/
//
//
//		DirectX	[ window.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/11
/*---------------------------------------------------------------
Update : 2017/5/11
			window.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


#include "window.h"
#include "resource.h"

#include <time.h>

#include "system_component.h"

#include "game_manager.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define CLASS_NAME APPLICATION_NAME							// EBhENX̖O

#define WIN_STYLE ( WS_OVERLAPPEDWINDOW \
	^ (WS_THICKFRAME & WS_SIZEBOX) )						// windowstylẽ}N

#define TIMER_INTERVAL (1000/60)							// Ԋu601b

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

const int Window::SCREEN_WIDTH  = WINDOW_WIDTH; 
const int Window::SCREEN_HEIGHT = WINDOW_HEIGHT; 
Window* Window::pWindow = nullptr;
std::map<unsigned int,MethodFunc> Window::CallBackMethod;

int Window::height = 0;
int Window::width  = 0;




// Window Constructor
Window::Window( )
	: hWnd( nullptr )
	, FPSCounter(0)
{

	// Registry WindowClassPointer
	if( !pWindow ){
		pWindow = this;
	}

	// Add Msg < Method >
	CallBackMethod[WM_CLOSE]     = ProcMethod::CloseWinMsg;
	CallBackMethod[WM_DESTROY]   = ProcMethod::DestoryWinMsg;
	CallBackMethod[WM_KEYDOWN]   = ProcMethod::KeydownWinMsg;

	// for drop file
	CallBackMethod[WM_CREATE]    = ProcMethod::CreateWinMsg;
	CallBackMethod[WM_DROPFILES] = ProcMethod::DropFileWinMsg;

	// for tool method

}

// Window Destructor
Window::~Window( )
{

	// Do Nothing!!

}

// Window Create Instance 
Window* Window::Create( void )
{

	// Create Class Instance
	Window* pObject;
	pObject = new Window;

	return pObject;

}

// Window Initialize
bool Window::Init( HINSTANCE hInstance,	HINSTANCE hPravInstance, LPTSTR IpCmdLine, int nCmdShow )
{
	
	// THIS APPLICATION DONT USE STATUS 
	UNREFERENCED_PARAMETER( hPravInstance );
	
	// Registry WindowClass
	MyRegisterClass( hInstance );

	// Initialize Application
	if (!InitInstance ( hInstance, nCmdShow )){
		MessageBox( NULL, "Application Dont Play!!", "Application ERROR!!", 0 );
		return false;
	}
	
	{ // Initialize Process

		pManager = GameManager::Create( );
		pManager ->Init( hWnd, true );

	} // Application Initialize -> END

	return true;

}

// Window Uninitialize
int Window::Uninit( void )
{

	// Uninitialize Process
	pManager->Uninit( );

	// ȑOɃZbgꂽŏ^C}\NA
	timeEndPeriod( 1 );

	return (int) msg.wParam;

}

// Window Update
void Window::Application( void )
{

	// Update Process
	
	// \̐ݒ
	timeBeginPeriod( 1 );

	// eJE^[̏
	DWORD dwFrameCount = 0;
	DWORD dwCurrentTime = 0;
	DWORD dwExecLastTime = timeGetTime();			// ݂̎~bPʂŎ擾
	DWORD dwFPSLastTime = dwExecLastTime;			// Ԃ𓯊
		
	//bZ\W[v
	for(;;){
		if( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE)!=0 ){
			//windows̏
			if(msg.message==WM_QUIT){
				break;
			}
			else{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else{
			dwCurrentTime = timeGetTime( );		// ݂̎~bPʂŎ擾
			
			if( (dwCurrentTime-dwFPSLastTime) >= 500 ){

				FPSCounter=(dwFrameCount*1000)/(dwCurrentTime-dwFPSLastTime);
				dwFPSLastTime = dwCurrentTime;
				dwFrameCount=0;
			}
			if( (dwCurrentTime - dwExecLastTime) >= ( TIMER_INTERVAL ) ){

				dwExecLastTime=dwCurrentTime;	// Ԃۑ

				pManager->Update( );
				pManager->Draw( );
				dwFrameCount++;
			}
		}
	}

	

}

// Registry WindowClass
ATOM Window::MyRegisterClass(HINSTANCE hInstance)
{
	
	WNDCLASSEX wcex = {
		sizeof(WNDCLASSEX),							// WNDCALSSEX̃TCYw
		CS_CLASSDC,									// \EBhẼX^Cݒ
		WndProc,									//   EBhEvV[W̃AhX(֐)w
		0,											// ʏ͎gpȂ̂"0"w
		0,											// ʏ͎gpȂ̂"0"wx
		hInstance,									//   WinMaiñp[^̃CX^Xnhݒ
		LoadIcon(hInstance, TEXT("KITTY")),			// gpACRw(WindowĂACRg)
		LoadCursor(NULL, IDC_CROSS),				// }EXJ[\w
		(HBRUSH)(COLOR_WINDOW + 1),					// EBhẼNCAg̈̔wiFݒ
		NULL,										// Windowsɂ郁j[ݒ
		CLASS_NAME,									//   EBhENX̖O
		NULL										// ACRݒ肳ꂽꍇ̏Lq
	};

	return RegisterClassEx(&wcex);

	
}

// Create Window Process 
bool Window::InitInstance(HINSTANCE hInstance, int nCmdShow)
{


	RECT cr = { 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT };
	AdjustWindowRect( &cr, WIN_STYLE, FALSE );

	RECT dr = {};
	GetWindowRect( GetDesktopWindow( ),&dr );
	int windowX = (cr.right-cr.left)>(dr.right-dr.left) ? 0:((dr.right-dr.left)-(cr.right-cr.left))/2;
	int windowY = (cr.bottom-cr.top)>(dr.bottom-dr.top) ? 0:((dr.bottom-dr.top)-(cr.bottom-cr.top))/2;

	// EBhE쐬
	hWnd = CreateWindowEx(
	WS_EX_ACCEPTFILES,								// gEBhEX^C
	CLASS_NAME,										// EBhENX̖O
	APPLICATION_NAME,								// EBhE̖O
	WIN_STYLE,										// EBhEX^C
	windowX,										// EBhE̍XW
	windowY,										// EBhE̍YW
	cr.right-cr.left,								// EBhE̕
	cr.bottom-cr.top,								// EBhE̍
	NULL,											// eEBhẼnh
	NULL,											// j[nh܂͎qEBhEID
	hInstance,										// CX^Xnh
	NULL);											// EBhE쐬f[^

   if (!hWnd)
   {
      return FALSE;
   }
	
	// EBhE̕\
	ShowWindow( hWnd, nCmdShow );
	UpdateWindow( hWnd );

	return TRUE;
	
}

// Window Proc
LRESULT CALLBACK Window::WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{

	// Window Message
	if( CallBackMethod.find(uMsg) != CallBackMethod.end() ){
		CallBackMethod[uMsg](hWnd,uMsg,wParam,lParam);
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);

}

// Window Get Window Handle
HWND Window::GetWindowHandle( void )
{

	// Window Get Window Handle
	return pWindow->hWnd;

}

// Window Get Update Frame/Second
int Window::GetFPS( void )
{

	// Window Get Update Frame/Second
	return (pWindow->FPSCounter);

}







